\name{plot.biwavelet}
\alias{plot.biwavelet}
\title{
Plot \code{biwavelet} objects
}
\description{
Plot \code{biwavelet} objects such as the cwt, cross-wavelet and wavelet coherence
}
\usage{
\method{plot}{biwavelet} (x, ncol = 64, xlab = "Time", ylab = "Period", main = NULL, 
               sig.level = 0.95, plot.cb = FALSE, plot.phase = FALSE, 
               type = c("power.norm", "power", "wavelet", "phase"), 
               plot.coi = TRUE, plot.sig = TRUE, bw = FALSE, 
               legend.loc = c(0.885, 0.92, 0.2, 0.8), 
               legend.horiz = FALSE, arrow.size = 0.08, 
               arrow.lwd = 2, arrow.cutoff = 0.9, form='\%Y', \dots)
}
\arguments{
  \item{x}{
\code{biwavelet} object generated by \code{wt}, \code{xwt}, or \code{wtc}.
}
  \item{ncol}{
number of colors to use. Default is 64.
}
  \item{xlab}{
xlabel of the figure. Default is "Time"
}
  \item{ylab}{
ylabel of the figure. Default is "Period"
}
  \item{main}{
title of the figure. Default is blank.
}
  \item{sig.level}{
significance level for contours. Default is 0.95.
}
  \item{plot.cb}{
plot color bar if TRUE. Default is FALSE.
}
  \item{plot.phase}{
Plot phases with black arrows. Default is FALSE.
}
  \item{type}{
type of plot to create. Can be \code{power} to plot the power, \code{power.norm}
to plot the power normalized by the variance, \code{wavelet} to plot the 
wavelet coefficients, or \code{phase} to plot the phase. Default is power.norm.
}
  \item{plot.coi}{
plot cone of influence (COI) if TRUE. Default is TRUE. Areas that fall outside 
of the COI can be affected by edge effects.
}
  \item{plot.sig}{
plot contours for significance if TRUE. Default is TRUE.
}
  \item{bw}{
plot in black and white if TRUE. Default is FALSE.
}
  \item{legend.loc}{
legend location coordinates as defined by \code{image.plot}. Default is
\code{c(0.885, 0.92, 0.2, 0.8)}.
}
  \item{legend.horiz}{
plot a horizontal legend if TRUE. Default is FALSE.
}
  \item{arrow.size}{
size of the arrows. Default is 0.08.
}
  \item{arrow.lwd}{
width/thickness of arrows. Default is 2.
}
  \item{arrow.cutoff}{
cutoff value for plotting arrows. z-values that fall below the \code{arrow.cutoff}
quantile will not be plotted. Default is 0.9.
}
\item{form}{
format to use to display dates on the x-axis. Default is '\%Y' for 4-digit year.
See \code{?Date} for other valid formats.
}
  \item{\dots}{
other parameters.
}
}
\details{
Arrows pointing to the right mean that \code{x} and \code{y} are in phase.

Arrows pointing to the left mean that \code{x} and \code{y} are in anti-phase.

Arrows pointing up mean that \code{y} leads \code{x} by \eqn{\pi/2}.

Arrows pointing down mean that \code{x} leads \code{y} by \eqn{\pi/2}.
}

\references{
Cazelles, B., M. Chavez, D. Berteaux, F. Menard, J. O. Vik, S. Jenouvrier, and 
N. C. Stenseth. 2008. Wavelet analysis of ecological time series. 
\emph{Oecologia} 156:287-304.

Grinsted, A., J. C. Moore, and S. Jevrejeva. 2004. Application of the cross 
wavelet transform and wavelet coherence to geophysical time series. 
\emph{Nonlinear Processes in Geophysics} 11:561-566.

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis. 
\emph{Bulletin of the American Meteorological Society} 79:61-78.
}
\author{
Tarik C. Gouhier (tarik.gouhier@gmail.com)

Code based on WTC MATLAB package written by Aslak Grinsted.
}
\seealso{
\code{\link{image.plot}}
}

\examples{
t1=cbind(1:100, rnorm(100))
t2=cbind(1:100, rnorm(100))
## Continuous wavelet transform
wt.t1=wt(t1)
## Plot power
## Make room to the right for the color bar
par(oma=c(0, 0, 0, 1), mar=c(5, 4, 4, 5) + 0.1)
plot(wt.t1, plot.cb=TRUE, plot.phase=FALSE)

## Cross-wavelet transform
xwt.t1t2=xwt(t1, t2)
## Plot cross-wavelet
par(oma=c(0, 0, 0, 1), mar=c(5, 4, 4, 5) + 0.1)
plot(xwt.t1t2, plot.cb=TRUE)
}
