% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{blocks}
\alias{blocks}
\title{An enclosure for all HTML block functions}
\usage{
blocks(...)
}
\arguments{
\item{...}{One or more \code{block_*()} calls.}
}
\description{
To contain all of the block-based HTML \code{block_*()} calls, we should use
the \code{blocks()} function. We can pass the resulting \code{blocks} object to either
of the \code{body}, \code{header}, and \code{footer} arguments of \code{compose_email()}.
}
\examples{
# This is an example of how a
# title and text looks in each of
# the three content areas
email <-
  compose_email(
    header =
      blocks(
        block_title("This is a Title in the **Header**"),
        block_text("This is text in the **Header**.")
      ),
    body =
      blocks(
        block_title("This is a Title in the **Body**"),
        block_text("This is text in the **Body**.")
      ),
    footer =
      blocks(
        block_title("This is a Title in the **Footer**"),
        block_text("This is text in the **Footer**.")
      )
  )

if (interactive()) email

}
