% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smtp_send.R
\name{smtp_send}
\alias{smtp_send}
\title{Send an email message through SMTP}
\usage{
smtp_send(email, to, from, subject = NULL, cc = NULL, bcc = NULL,
  credentials = NULL, creds_file = "deprecated", verbose = FALSE)
}
\arguments{
\item{email}{The email message object, as created by the \code{\link[=compose_email]{compose_email()}}
function. The object's class is \code{email_message}.}

\item{to}{A vector of email addresses serving as primary recipients for the
message. For secondary recipients, use the \code{cc} and \code{bcc} arguments. A
named character vector can be used to specify the recipient names along
with the their email address (e.g., \code{c("Jane Doe" = "jane_doe@example.com")}).}

\item{from}{The email address of the sender. Often this needs to be the same
email address that is associated with the account actually sending the
message. As with \code{to}, \code{cc}, and \code{bcc}, we can either supply a single email
address or use a named character vector with the sender name and email
address (e.g., \code{c("John Doe" = "john_doe@example.com")}).}

\item{subject}{The subject of the message, which is usually a brief summary
of the topic of the message. If not provided, an empty string will be used
(which is handled differently by email clients).}

\item{cc, bcc}{A vector of email addresses for sending the message as a carbon
copy or blind carbon copy. The CC list pertains to recipients that are to
receive a copy of a message that is addressed primarily to others. The CC
listing of recipients is visible to all other recipients of the message.
The BCC list differs in that those recipients will be concealed from all
other recipients (including those on the BCC list). A named character
vector can be used to specify the recipient names along with the their
email address (e.g., \code{c("Joe Public" = "joe_public@example.com")}).}

\item{credentials}{One of three credential helper functions must be used
here: (1) \code{\link[=creds]{creds()}}, (2) \code{\link[=creds_key]{creds_key()}}, or (3) \code{\link[=creds_file]{creds_file()}}. The first,
\code{\link[=creds]{creds()}}, allows for a manual specification of SMTP configuration and
credentials within that helper function. This is the most secure method for
supplying credentials as they aren't written to disk. The \code{\link[=creds_key]{creds_key()}}
function is used if credentials are stored in the system-wide key-value
store, through use of the \code{\link[=create_smtp_creds_key]{create_smtp_creds_key()}} function. The
\code{\link[=creds_file]{creds_file()}} helper function relies on a credentials file stored on disk.
Such a file is created using the \code{\link[=create_smtp_creds_file]{create_smtp_creds_file()}} function.}

\item{creds_file}{An option to specify a credentials file. As this argument
is deprecated, please consider using \code{credentials = creds_file(<file>)}
instead.}

\item{verbose}{Should verbose output from the internal curl \code{send_mail()}
call be printed? While the username and password will likely be echoed
during the exchange, such information is encoded and won't be stored on
the user's system.}
}
\description{
Send an email message to one or more recipients via an SMTP server. The email
message required as input to \code{smtp_send()} has to be created by using the
\code{\link[=compose_email]{compose_email()}} function. The \code{email_message} object can be previewed by
printing the object, where the HTML preview will show how the message should
appear in recipients' email clients. File attachments can be added to the
email object by using the \code{\link[=add_attachment]{add_attachment()}} function (one call per
attachment) prior to sending through this function.
}
\details{
We can avoid re-entering SMTP configuration and credentials information by
retrieving this information either from disk (with the file generated by use
of the \code{\link[=create_smtp_creds_file]{create_smtp_creds_file()}} function), or, from the system's key-value
store (with the key set by the \code{\link[=create_smtp_creds_key]{create_smtp_creds_key()}} function).
}
\examples{
# Before sending out an email through
# SMTP, we need an `email_message`
# object; for the purpose of a simple
# example, we can use the function
# `prepare_test_message()` to create
# a test version of an email (although
# we'd normally use `compose_email()`)
email <- prepare_test_message()

# The `email` message can be sent
# through the `smtp_send()` function
# so long as we supply the appropriate
# credentials; The following three
# examples provide scenarios for both
# the creation of credentials and their
# retrieval within the `credentials`
# argument of `smtp_send()`

# (1) Providing the credentials info
# directly via the `creds()` helper
# (the most secure means of supplying
# credentials information)

# email \%>\%
#   smtp_send(
#     from = "sender@email.com",
#     to = "recipient@email.com",
#     credentials = creds(
#       provider = "gmail",
#       user = "sender@email.com")
#   )

# (2) Using a credentials key (with
# the `create_smtp_creds_key()` and
# `creds_key()` functions)

# create_smtp_creds_key(
#  id = "gmail",
#  user = "sender@email.com",
#  provider = "gmail"
#  )

# email \%>\%
#   smtp_send(
#     from = "sender@email.com",
#     to = "recipient@email.com",
#     credentials = creds_key(
#       "gmail"
#       )
#   )

# (3) Using a credentials file (with
# the `create_smtp_creds_file()` and
# `creds_file()` functions)

# create_smtp_creds_file(
#  file = "gmail_secret",
#  user = "sender@email.com",
#  provider = "gmail"
#  )

# email \%>\%
#   smtp_send(
#     from = "sender@email.com",
#     to = "recipient@email.com",
#     credentials = creds_file(
#       "gmail_secret")
#   )

}
