% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{Student-class}
\alias{Student-class}
\alias{Student}
\alias{setupStudent}
\title{Student's t test}
\usage{
setupStudent(
  alpha,
  beta,
  r = 1,
  delta,
  delta_NI = 0,
  alternative = c("greater", "smaller"),
  n_max = Inf,
  ...
)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{delta_NI}{Non-inferiority margin.}

\item{alternative}{Does the alternative hypothesis contain greater
(\code{greater}) or smaller (\code{smaller}) values than the
null hypothesis.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{Student}}.
}
\description{
This class implements Student's t-test for superiority and non-inferiority
tests.
A trial with continuous outcomes of the two groups \code{T} and \code{C}
is assumed.
If \code{alternative == "greater"} the null hypothesis for the
mean difference
\ifelse{html}{\out{&Delta; = &mu;<sub>T</sub> - &mu;<sub>C</sub>}}{\eqn{\Delta = \mu_T - \mu_C}}
is
\ifelse{html}{\out{<p>H<sub>0</sub>: &Delta; &le; -&delta;<sub>NI</sub>  vs.  H<sub>1</sub>: &Delta; > -&delta;<sub>NI</sub>.</p>}}{\deqn{H_0: \Delta \leq -\delta_{NI}  vs.  H_1: \Delta > -\delta_{NI}.}}
Here, \ifelse{html}{\out{&delta;<sub>NI</sub> &ge; 0}}{\eqn{\delta_{NI} \geq 0}} denotes the non-inferiority margin.
For superiority trials, \ifelse{html}{\out{&delta;<sub>NI</sub>}}{\eqn{\delta_{NI}}}
can be set to zero (default).
If \code{alternative=="smaller"}, the direction of the effect is changed.

The function \code{setupStudent} creates an object of class
\code{\link{Student}} that can be used for sample size recalculation.
}
\details{
The notation is based on the paper of Lu (2019):
Distribution of the two-sample t-test statistic following blinded
sample size re-estimation. Pharmaceutical Statistics 15: 208-215.

The following methods are available for this class:
\code{\link{toer}}, \code{\link{pow}}, \code{\link{n_dist}},
\code{\link{adjusted_alpha}}, and \code{\link{n_fix}}.
Check the design specific documentation for details.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                   alternative = "greater", n_max = 156)
}
