% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-stepwise-selection.R
\name{blr_step_aic_both}
\alias{blr_step_aic_both}
\alias{plot.blr_step_aic_both}
\title{Stepwise AIC selection}
\usage{
blr_step_aic_both(model, details = FALSE, ...)

\method{plot}{blr_step_aic_both}(x, text_size = 3, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{details}{Logical; if \code{TRUE}, details of variable selection will be
printed on screen.}

\item{...}{Other arguments.}

\item{x}{An object of class \code{blr_step_aic_both}.}

\item{text_size}{size of the text in the plot.}
}
\value{
\code{blr_step_aic_both} returns an object of class \code{"blr_step_aic_both"}.
An object of class \code{"blr_step_aic_both"} is a list containing the
following components:

\item{candidates}{candidate predictor variables}
\item{predictors}{variables added/removed from the model}
\item{method}{addition/deletion}
\item{aics}{akaike information criteria}
\item{bics}{bayesian information criteria}
\item{devs}{deviances}
\item{steps}{total number of steps}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on akaike information criterion, in a
stepwise manner until there is no variable left to enter or remove any more.
}
\examples{
\dontrun{
model <- glm(y ~ ., data = stepwise)

# selection summary
blr_step_aic_both(model)

# print details at each step
blr_step_aic_both(model, details = TRUE)

# plot
plot(blr_step_aic_both(model))
}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: \code{\link{blr_step_aic_backward}},
  \code{\link{blr_step_aic_forward}},
  \code{\link{blr_step_p_backward}},
  \code{\link{blr_step_p_forward}}
}
