% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bls_key.R
\name{set_bls_key}
\alias{set_bls_key}
\title{Install a BLS API Key in Your \code{.Renviron} File for Repeated Use}
\usage{
set_bls_key(key = NA, overwrite = NA)
}
\arguments{
\item{key}{The API key provided to you from the BLS formated in quotes. A key can be aquired at \url{https://data.bls.gov/registrationEngine/}}

\item{overwrite}{If this is set to TRUE, it will overwrite an existing BLS_KEY that you already have in your \code{.Renviron} file.}
}
\description{
This function will add your BLS API key to your \code{.Renviron} file so it can be called securely without being stored 
in your code. After you have installed your key, it can be called any time by typing \code{Sys.getenv("BLS_KEY")} and can be 
used in package functions by simply typing BLS_KEY. If you do not have an \code{.Renviron} file, the function will create on for you. 
If you already have an \code{.Renviron} file, the function will append the key to your existing file, while making a backup of your 
original file for disaster recovery purposes.
}
\examples{

\dontrun{
set_bls_key("111111abc")
# First time, relead your enviornment so you can use the key without restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("BLS_KEY")
}

\dontrun{
# If you need to overwrite an existing key:
set_bls_key("111111abc", overwrite = TRUE)
# First time, relead your enviornment so you can use the key without restarting R.
readRenviron("~/.Renviron")
# You can check it with:
Sys.getenv("BLS_KEY")
}
}

