n = 20000

STRENGTH = c("None", "Weak", "Strong")
VERT = c("StrongUp", "WeakUp", "Neutral", "Down")
CLOUDY = c("Cloudy", "PC", "Clear")
INHIBIT = c("None", "PartInhibit", "Stifling", "TotalInhibit")
WET = c("VeryWet", "Wet", "Neutral", "Dry")
DEWPOINTS = c("LowEvrywhere", "LowAtStation", "LowSHighN", "LowNHighS", "LowMtsHighPl", "HighEvrywher", "Other")
WIND = c("DenvCyclone", "E_W_N", "E_W_S", "MovingFtorOt", "DryLine", "None", "Other")
PLN = c("LV", "DenvCyclone", "LongAnticyc", "E_NE", "SEQuad", "WidespdDnsl")
SYN = c("SigNegative", "NegToPos", "SigPositive", "PosToNeg", "LittleChange")
MOIST = c("VeryMoist", "Average", "Dry")
LL = c("CloseToDryAd", "Steep", "ModerateOrLe")
LL2 = c(LL, "Stable")
AVE = c("LessThanAve", "Average", "MoreThanAve")
STRENGTH2 = c("None", "Slight", "Moderate", "Strong")
FCST = c("IncCapDecIns", "LittleChange", "DecCapIncIns")
FCST2 = c("XNIL", "SIG", "SVR")
UNST = c("LessUnstable", "Average", "MoreUnstable")
DEC = c("Decreasing", "LittleChange", "Increasing")
SHADE = c("None", "Some", "Marked")
WND = c("DCVZFavor", "StrongWest", "Westerly", "Other")
LOLEV = c("StrongPos", "WeakPos", "Neutral", "Negative")
DATE = c("May15_Jun14", "Jun15_Jul1", "Jul2_Jul15", "Jul16_Aug10", "Aug11_Aug20", "Aug20_Sep15")
SAMI = c("ABI", "CDEJ", "F", "G", "H", "K")
LIFR = c("LIGt0", "N1GtLIGt_4", "N5GtLIGt_8", "LILt_8")
LLEV = c("Unfavorable", "Weak", "Moderate", "Strong") 
MVMT = c("StrongFront", "MarkedUpper", "OtherRapid", "NoMajor")
RHRLV = c("MoistMDryL", "DryMMoistL", "Other")
TDISLV = c("QStationary", "Moving", "None", "Other")
WLOFT = c("LV", "SWQuad", "NWQuad", "AllElse")
SC34 = c("ACEFK", "B", "D", "GJ", "HI")
AMDEW = c("Instability", "Neutral", "Stability")
WNDMT = c("Westerly", "LVorOther")
SCRLAM = c("AB", "CThruK")

AMDewptCalPl = sample(AMDEW, n, prob = c(0.3, 0.25, 0.45), replace = TRUE)
MorningBound = sample(STRENGTH, n, prob = c(0.5, 0.35, 0.15), replace = TRUE)
LoLevMoistAd = sample(LOLEV, n, prob = c(0.12, 0.28, 0.3, 0.3), replace = TRUE)
QGVertMotion = sample(VERT, n, prob = c(0.15, 0.15, 0.5, 0.2), replace = TRUE)
MorningCIN = sample(INHIBIT, n, prob = c(0.15, 0.57, 0.2, 0.08), replace = TRUE)
Date = sample(DATE, n, prob = c(0.254098, 0.131148, 0.106557, 0.213115, 0.07377, 0.221312), replace = TRUE)
AMInstabMt = sample(STRENGTH, n, prob = c(1/3, 1/3, 1/3), replace = TRUE)
LLIW = sample(LLEV, n, prob = c(0.12, 0.32, 0.38, 0.18), replace = TRUE)
IRCloudCover = sample(CLOUDY, n, prob = c(0.15, 0.45, 0.4), replace = TRUE)
LatestCIN = sample(INHIBIT, n, prob = c(0.4, 0.4, 0.15, 0.05), replace = TRUE)
N07muVerMo = sample(VERT, n, prob = c(0.25, 0.25, 0.25, 0.25), replace = TRUE)
RaoContMoist = sample(WET, n, prob = c(0.15, 0.2, 0.4, 0.25), replace = TRUE)
SubjVertMo = sample(VERT, n, prob = c(0.15, 0.15, 0.5, 0.2), replace = TRUE)
WndHodograph = sample(WND, n, prob = c(0.3, 0.25, 0.25, 0.2), replace = TRUE)
LIfr12ZDENSd = sample(LIFR, n, prob = c(0.1, 0.52, 0.3, 0.08), replace = TRUE)
SatContMoist = sample(WET, n, prob = c(0.15, 0.2, 0.4, 0.25), replace = TRUE)
VISCloudCov = sample(CLOUDY, n, prob = c(0.1, 0.5, 0.4), replace = TRUE)

Scenario = Date
Scenario[Scenario == "May15_Jun14"] = sample(LETTERS[1:11], length(which(Scenario == "May15_Jun14")), prob = c(0.1, 0.16, 0.1, 0.08, 0.08, 0.01, 0.08, 0.1, 0.09, 0.03, 0.17), replace = TRUE)
Scenario[Scenario == "Jun15_Jul1"] = sample(LETTERS[1:11], length(which(Scenario == "Jun15_Jul1")), prob = c(0.05, 0.16, 0.09, 0.09, 0.12, 0.02, 0.13, 0.06, 0.07, 0.11, 0.1), replace = TRUE)
Scenario[Scenario == "Jul2_Jul15"] = sample(LETTERS[1:11], length(which(Scenario == "Jul2_Jul15")), prob = c(0.04, 0.13, 0.1, 0.08, 0.15, 0.03, 0.14, 0.04, 0.06, 0.15, 0.08), replace = TRUE)
Scenario[Scenario == "Jul16_Aug10"] = sample(LETTERS[1:11], length(which(Scenario == "Jul16_Aug10")), prob = c(0.04, 0.13, 0.09, 0.07, 0.2, 0.08, 0.06, 0.05, 0.07, 0.13, 0.08), replace = TRUE)
Scenario[Scenario == "Aug11_Aug20"] = sample(LETTERS[1:11], length(which(Scenario == "Aug11_Aug20")), prob = c(0.04, 0.11, 0.1, 0.07, 0.17, 0.05, 0.1, 0.05, 0.07, 0.14, 0.1), replace = TRUE)
Scenario[Scenario == "Aug20_Sep15"] = sample(LETTERS[1:11], length(which(Scenario == "Aug20_Sep15")), prob = c(0.05, 0.11, 0.1, 0.08, 0.11, 0.02, 0.11, 0.06, 0.08, 0.11, 0.17), replace = TRUE)

WindFieldMt = Scenario
WindFieldMt[WindFieldMt == "A"] = sample(WNDMT, length(which(WindFieldMt == "A")), prob = c(0.8, 0.2), replace = TRUE)
WindFieldMt[WindFieldMt == "B"] = sample(WNDMT, length(which(WindFieldMt == "B")), prob = c(0.35, 0.65), replace = TRUE)
WindFieldMt[WindFieldMt == "C"] = sample(WNDMT, length(which(WindFieldMt == "C")), prob = c(0.75, 0.25), replace = TRUE)
WindFieldMt[WindFieldMt == "D"] = sample(WNDMT, length(which(WindFieldMt == "D")), prob = c(0.7, 0.3), replace = TRUE)
WindFieldMt[WindFieldMt == "E"] = sample(WNDMT, length(which(WindFieldMt == "E")), prob = c(0.65, 0.35), replace = TRUE)
WindFieldMt[WindFieldMt == "F"] = sample(WNDMT, length(which(WindFieldMt == "F")), prob = c(0.15, 0.85), replace = TRUE)
WindFieldMt[WindFieldMt == "G"] = sample(WNDMT, length(which(WindFieldMt == "G")), prob = c(0.7, 0.3), replace = TRUE)
WindFieldMt[WindFieldMt == "H"] = sample(WNDMT, length(which(WindFieldMt == "H")), prob = c(0.3, 0.7), replace = TRUE)
WindFieldMt[WindFieldMt == "I"] = sample(WNDMT, length(which(WindFieldMt == "I")), prob = c(0.5, 0.5), replace = TRUE)
WindFieldMt[WindFieldMt == "J"] = sample(WNDMT, length(which(WindFieldMt == "J")), prob = c(0.01, 0.99), replace = TRUE)
WindFieldMt[WindFieldMt == "K"] = sample(WNDMT, length(which(WindFieldMt == "K")), prob = c(0.7, 0.3), replace = TRUE)

MvmtFeatures = Scenario
MvmtFeatures[MvmtFeatures == "A"] = sample(MVMT, length(which(MvmtFeatures == "A")), prob = c(0.25, 0.55, 0.2, 0), replace = TRUE)
MvmtFeatures[MvmtFeatures == "B"] = sample(MVMT, length(which(MvmtFeatures == "B")), prob = c(0.05, 0.1, 0.1, 0.75), replace = TRUE)
MvmtFeatures[MvmtFeatures == "C"] = sample(MVMT, length(which(MvmtFeatures == "C")), prob = c(0.1, 0.3, 0.3, 0.3), replace = TRUE)
MvmtFeatures[MvmtFeatures == "D"] = sample(MVMT, length(which(MvmtFeatures == "D")), prob = c(0.18, 0.38, 0.34, 0.1), replace = TRUE)
MvmtFeatures[MvmtFeatures == "E"] = sample(MVMT, length(which(MvmtFeatures == "E")), prob = c(0.02, 0.02, 0.26, 0.7), replace = TRUE)
MvmtFeatures[MvmtFeatures == "F"] = sample(MVMT, length(which(MvmtFeatures == "F")), prob = c(0.05, 0.07, 0.05, 0.83), replace = TRUE)
MvmtFeatures[MvmtFeatures == "G"] = sample(MVMT, length(which(MvmtFeatures == "G")), prob = c(0.1, 0.25, 0.15, 0.5), replace = TRUE)
MvmtFeatures[MvmtFeatures == "H"] = sample(MVMT, length(which(MvmtFeatures == "H")), prob = c(0, 0.6, 0.1, 0.3), replace = TRUE)
MvmtFeatures[MvmtFeatures == "I"] = sample(MVMT, length(which(MvmtFeatures == "I")), prob = c(0.2, 0.1, 0.2, 0.5), replace = TRUE)
MvmtFeatures[MvmtFeatures == "J"] = sample(MVMT, length(which(MvmtFeatures == "J")), prob = c(0.04, 0, 0.04, 0.92), replace = TRUE)
MvmtFeatures[MvmtFeatures == "K"] = sample(MVMT, length(which(MvmtFeatures == "K")), prob = c(0.5, 0.35, 0.09, 0.06), replace = TRUE)

MidLLapse = Scenario
MidLLapse[MidLLapse == "A"] = sample(LL, length(which(MidLLapse == "A")), prob = c(0.25, 0.55, 0.2), replace = TRUE)
MidLLapse[MidLLapse == "B"] = sample(LL, length(which(MidLLapse == "B")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
MidLLapse[MidLLapse == "C"] = sample(LL, length(which(MidLLapse == "C")), prob = c(0.4, 0.38, 0.22), replace = TRUE)
MidLLapse[MidLLapse == "D"] = sample(LL, length(which(MidLLapse == "D")), prob = c(0.43, 0.37, 0.2), replace = TRUE)
MidLLapse[MidLLapse == "E"] = sample(LL, length(which(MidLLapse == "E")), prob = c(0.02, 0.38, 0.6), replace = TRUE)
MidLLapse[MidLLapse == "F"] = sample(LL, length(which(MidLLapse == "F")), prob = c(0, 0.1, 0.9), replace = TRUE)
MidLLapse[MidLLapse == "G"] = sample(LL, length(which(MidLLapse == "G")), prob = c(0.84, 0.16, 0), replace = TRUE)
MidLLapse[MidLLapse == "H"] = sample(LL, length(which(MidLLapse == "H")), prob = c(0.25, 0.31, 0.44), replace = TRUE)
MidLLapse[MidLLapse == "I"] = sample(LL, length(which(MidLLapse == "I")), prob = c(0.41, 0.29, 0.3), replace = TRUE)
MidLLapse[MidLLapse == "J"] = sample(LL, length(which(MidLLapse == "J")), prob = c(0.23, 0.42, 0.35), replace = TRUE)
MidLLapse[MidLLapse == "K"] = sample(LL, length(which(MidLLapse == "K")), prob = c(0.16, 0.28, 0.56), replace = TRUE)

Dewpoints = Scenario
Dewpoints[Dewpoints == "A"] = sample(DEWPOINTS, length(which(Dewpoints == "A")), prob = c(0.04, 0.05, 0.15, 0.05, 0.19, 0.3, 0.22), replace = TRUE)
Dewpoints[Dewpoints == "B"] = sample(DEWPOINTS, length(which(Dewpoints == "B")), prob = c(0.05, 0.07, 0.15, 0.1, 0.3, 0.27, 0.06), replace = TRUE)
Dewpoints[Dewpoints == "C"] = sample(DEWPOINTS, length(which(Dewpoints == "C")), prob = c(0.4, 0.25, 0, 0.15, 0.05, 0.02, 0.13), replace = TRUE)
Dewpoints[Dewpoints == "D"] = sample(DEWPOINTS, length(which(Dewpoints == "D")), prob = c(0.13, 0.22, 0.18, 0.07, 0.34, 0.03, 0.03), replace = TRUE)
Dewpoints[Dewpoints == "E"] = sample(DEWPOINTS, length(which(Dewpoints == "E")), prob = c(0.15, 0.2, 0.2, 0.18, 0.11, 0.11, 0.05), replace = TRUE)
Dewpoints[Dewpoints == "F"] = sample(DEWPOINTS, length(which(Dewpoints == "F")), prob = c(0, 0, 0, 0, 0, 0.98, 0.02), replace = TRUE)
Dewpoints[Dewpoints == "G"] = sample(DEWPOINTS, length(which(Dewpoints == "G")), prob = c(0.5, 0.27, 0.15, 0.02, 0.02, 0, 0.04), replace = TRUE)
Dewpoints[Dewpoints == "H"] = sample(DEWPOINTS, length(which(Dewpoints == "H")), prob = c(0, 0.02, 0.1, 0.05, 0.5, 0.2, 0.13), replace = TRUE)
Dewpoints[Dewpoints == "I"] = sample(DEWPOINTS, length(which(Dewpoints == "I")), prob = c(0, 0.02, 0.7, 0, 0.2, 0.04, 0.04), replace = TRUE)
Dewpoints[Dewpoints == "J"] = sample(DEWPOINTS, length(which(Dewpoints == "J")), prob = c(0.1, 0.45, 0.1, 0.05, 0.26, 0.02, 0.02), replace = TRUE)
Dewpoints[Dewpoints == "K"] = sample(DEWPOINTS, length(which(Dewpoints == "K")), prob = c(0.1, 0.1, 0.1, 0.2, 0.05, 0.1, 0.35), replace = TRUE)

SfcWndShfDis = Scenario
SfcWndShfDis[SfcWndShfDis == "A"] = sample(WIND, length(which(SfcWndShfDis == "A")), prob = c(0.65, 0.05, 0.1, 0.08, 0.04, 0.07, 0.01), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "B"] = sample(WIND, length(which(SfcWndShfDis == "B")), prob = c(0.65, 0.05, 0.1, 0.1, 0.02, 0.07, 0.01), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "C"] = sample(WIND, length(which(SfcWndShfDis == "C")), prob = c(0, 0.65, 0.2, 0.02, 0.06, 0.05, 0.02), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "D"] = sample(WIND, length(which(SfcWndShfDis == "D")), prob = c(0.12, 0.02, 0.02, 0.02, 0.45, 0.27, 0.1), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "E"] = sample(WIND, length(which(SfcWndShfDis == "E")), prob = c(0.06, 0.14, 0.04, 0.04, 0.25, 0.4, 0.07), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "F"] = sample(WIND, length(which(SfcWndShfDis == "F")), prob = c(0.1, 0.1, 0.1, 0.02, 0, 0.56, 0.12), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "G"] = sample(WIND, length(which(SfcWndShfDis == "G")), prob = c(0.02, 0.05, 0.05, 0, 0.35, 0.33, 0.2), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "H"] = sample(WIND, length(which(SfcWndShfDis == "H")), prob = c(0.01, 0.1, 0.15, 0.4, 0, 0.23, 0.11), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "I"] = sample(WIND, length(which(SfcWndShfDis == "I")), prob = c(0.02, 0.1, 0.5, 0.3, 0.01, 0.02, 0.05), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "J"] = sample(WIND, length(which(SfcWndShfDis == "J")), prob = c(0.06, 0.08, 0.04, 0.02, 0.6, 0.14, 0.06), replace = TRUE)
SfcWndShfDis[SfcWndShfDis == "K"] = sample(WIND, length(which(SfcWndShfDis == "K")), prob = c(0.05, 0.13, 0.05, 0.39, 0.13, 0.15, 0.1), replace = TRUE)

RHRatio = Scenario
RHRatio[RHRatio == "A"] = sample(RHRLV, length(which(RHRatio == "A")), prob = c(0.05, 0.5, 0.45), replace = TRUE)
RHRatio[RHRatio == "B"] = sample(RHRLV, length(which(RHRatio == "B")), prob = c(0.1, 0.5, 0.4), replace = TRUE)
RHRatio[RHRatio == "C"] = sample(RHRLV, length(which(RHRatio == "C")), prob = c(0.4, 0.15, 0.45), replace = TRUE)
RHRatio[RHRatio == "D"] = sample(RHRLV, length(which(RHRatio == "D")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
RHRatio[RHRatio == "E"] = sample(RHRLV, length(which(RHRatio == "E")), prob = c(0.8, 0.05, 0.15), replace = TRUE)
RHRatio[RHRatio == "F"] = sample(RHRLV, length(which(RHRatio == "F")), prob = c(0, 0, 1), replace = TRUE)
RHRatio[RHRatio == "G"] = sample(RHRLV, length(which(RHRatio == "G")), prob = c(0.6, 0, 0.4), replace = TRUE)
RHRatio[RHRatio == "H"] = sample(RHRLV, length(which(RHRatio == "H")), prob = c(0, 0.7, 0.3), replace = TRUE)
RHRatio[RHRatio == "I"] = sample(RHRLV, length(which(RHRatio == "I")), prob = c(0.1, 0.7, 0.2), replace = TRUE)
RHRatio[RHRatio == "J"] = sample(RHRLV, length(which(RHRatio == "J")), prob = c(0.4, 0.4, 0.2), replace = TRUE)
RHRatio[RHRatio == "K"] = sample(RHRLV, length(which(RHRatio == "K")), prob = c(0.15, 0.45, 0.4), replace = TRUE)

ScenRelAMIns = Scenario
ScenRelAMIns[ScenRelAMIns == "A"] = sample(SAMI, length(which(ScenRelAMIns == "A")), prob = c(1, 0, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "B"] = sample(SAMI, length(which(ScenRelAMIns == "B")), prob = c(1, 0, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "C"] = sample(SAMI, length(which(ScenRelAMIns == "C")), prob = c(0, 1, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "D"] = sample(SAMI, length(which(ScenRelAMIns == "D")), prob = c(0, 1, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "E"] = sample(SAMI, length(which(ScenRelAMIns == "E")), prob = c(0, 1, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "F"] = sample(SAMI, length(which(ScenRelAMIns == "F")), prob = c(0, 0, 1, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "G"] = sample(SAMI, length(which(ScenRelAMIns == "G")), prob = c(0, 0, 0, 1, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "H"] = sample(SAMI, length(which(ScenRelAMIns == "H")), prob = c(0, 0, 0, 0, 1, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "I"] = sample(SAMI, length(which(ScenRelAMIns == "I")), prob = c(1, 0, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "J"] = sample(SAMI, length(which(ScenRelAMIns == "J")), prob = c(0, 1, 0, 0, 0, 0), replace = TRUE)
ScenRelAMIns[ScenRelAMIns == "K"] = sample(SAMI, length(which(ScenRelAMIns == "K")), prob = c(0, 0, 0, 0, 0, 1), replace = TRUE)

ScenRelAMCIN = Scenario
ScenRelAMCIN[ScenRelAMCIN == "A"] = sample(SCRLAM, length(which(ScenRelAMCIN == "A")), prob = c(1, 0), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "B"] = sample(SCRLAM, length(which(ScenRelAMCIN == "B")), prob = c(1, 0), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "C"] = sample(SCRLAM, length(which(ScenRelAMCIN == "C")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "D"] = sample(SCRLAM, length(which(ScenRelAMCIN == "D")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "E"] = sample(SCRLAM, length(which(ScenRelAMCIN == "E")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "F"] = sample(SCRLAM, length(which(ScenRelAMCIN == "F")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "G"] = sample(SCRLAM, length(which(ScenRelAMCIN == "G")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "H"] = sample(SCRLAM, length(which(ScenRelAMCIN == "H")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "I"] = sample(SCRLAM, length(which(ScenRelAMCIN == "I")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "J"] = sample(SCRLAM, length(which(ScenRelAMCIN == "J")), prob = c(0, 1), replace = TRUE)
ScenRelAMCIN[ScenRelAMCIN == "K"] = sample(SCRLAM, length(which(ScenRelAMCIN == "K")), prob = c(0, 1), replace = TRUE)

WindFieldPln = Scenario
WindFieldPln[WindFieldPln == "A"] = sample(PLN, length(which(WindFieldPln == "A")), prob = c(0.05, 0.6, 0.02, 0.1, 0.23, 0), replace = TRUE)
WindFieldPln[WindFieldPln == "B"] = sample(PLN, length(which(WindFieldPln == "B")), prob = c(0.08, 0.6, 0.02, 0.1, 0.2, 0), replace = TRUE)
WindFieldPln[WindFieldPln == "C"] = sample(PLN, length(which(WindFieldPln == "C")), prob = c(0.1, 0, 0.75, 0, 0, 0.15), replace = TRUE)
WindFieldPln[WindFieldPln == "D"] = sample(PLN, length(which(WindFieldPln == "D")), prob = c(0.1, 0.15, 0.2, 0.05, 0.3, 0.2), replace = TRUE)
WindFieldPln[WindFieldPln == "E"] = sample(PLN, length(which(WindFieldPln == "E")), prob = c(0.43, 0.1, 0.15, 0.06, 0.06, 0.2), replace = TRUE)
WindFieldPln[WindFieldPln == "F"] = sample(PLN, length(which(WindFieldPln == "F")), prob = c(0.6, 0.07, 0.01, 0.12, 0.2, 0), replace = TRUE)
WindFieldPln[WindFieldPln == "G"] = sample(PLN, length(which(WindFieldPln == "G")), prob = c(0.25, 0.01, 0.3, 0.01, 0.03, 0.4), replace = TRUE)
WindFieldPln[WindFieldPln == "H"] = sample(PLN, length(which(WindFieldPln == "H")), prob = c(0.04, 0.02, 0.04, 0.8, 0.1, 0), replace = TRUE)
WindFieldPln[WindFieldPln == "I"] = sample(PLN, length(which(WindFieldPln == "I")), prob = c(0.2, 0.3, 0.05, 0.37, 0.07, 0.01), replace = TRUE)
WindFieldPln[WindFieldPln == "J"] = sample(PLN, length(which(WindFieldPln == "J")), prob = c(0.6, 0.08, 0.07, 0.03, 0.2, 0.02), replace = TRUE)
WindFieldPln[WindFieldPln == "K"] = sample(PLN, length(which(WindFieldPln == "K")), prob = c(0.1, 0.05, 0.1, 0.05, 0.2, 0.5), replace = TRUE)

TempDis = Scenario
TempDis[TempDis == "A"] = sample(TDISLV, length(which(TempDis == "A")), prob = c(0.13, 0.15, 0.1, 0.62), replace = TRUE)
TempDis[TempDis == "B"] = sample(TDISLV, length(which(TempDis == "B")), prob = c(0.15, 0.15, 0.25, 0.45), replace = TRUE)
TempDis[TempDis == "C"] = sample(TDISLV, length(which(TempDis == "C")), prob = c(0.12, 0.1, 0.35, 0.43), replace = TRUE)
TempDis[TempDis == "D"] = sample(TDISLV, length(which(TempDis == "D")), prob = c(0.1, 0.15, 0.4, 0.35), replace = TRUE)
TempDis[TempDis == "E"] = sample(TDISLV, length(which(TempDis == "E")), prob = c(0.04, 0.04, 0.82, 0.1), replace = TRUE)
TempDis[TempDis == "F"] = sample(TDISLV, length(which(TempDis == "F")), prob = c(0.05, 0.12, 0.75, 0.08), replace = TRUE)
TempDis[TempDis == "G"] = sample(TDISLV, length(which(TempDis == "G")), prob = c(0.03, 0.03, 0.84, 0.1), replace = TRUE)
TempDis[TempDis == "H"] = sample(TDISLV, length(which(TempDis == "H")), prob = c(0.05, 0.4, 0.5, 0.05), replace = TRUE)
TempDis[TempDis == "I"] = sample(TDISLV, length(which(TempDis == "I")), prob = c(0.8, 0.19, 0, 0.01), replace = TRUE)
TempDis[TempDis == "J"] = sample(TDISLV, length(which(TempDis == "J")), prob = c(0.1, 0.05, 0.4, 0.45), replace = TRUE)
TempDis[TempDis == "K"] = sample(TDISLV, length(which(TempDis == "K")), prob = c(0.2, 0.3, 0.3, 0.2), replace = TRUE)

SynForcng = Scenario
SynForcng[SynForcng == "A"] = sample(SYN, length(which(SynForcng == "A")), prob = c(0.35, 0.25, 0, 0.35, 0.05), replace = TRUE)
SynForcng[SynForcng == "B"] = sample(SYN, length(which(SynForcng == "B")), prob = c(0.06, 0.1, 0.06, 0.3, 0.48), replace = TRUE)
SynForcng[SynForcng == "C"] = sample(SYN, length(which(SynForcng == "C")), prob = c(0.1, 0.27, 0.4, 0.08, 0.15), replace = TRUE)
SynForcng[SynForcng == "D"] = sample(SYN, length(which(SynForcng == "D")), prob = c(0.35, 0.2, 0.1, 0.25, 0.1), replace = TRUE)
SynForcng[SynForcng == "E"] = sample(SYN, length(which(SynForcng == "E")), prob = c(0.15, 0.15, 0.1, 0.15, 0.45), replace = TRUE)
SynForcng[SynForcng == "F"] = sample(SYN, length(which(SynForcng == "F")), prob = c(0.15, 0.1, 0.05, 0.15, 0.55), replace = TRUE)
SynForcng[SynForcng == "G"] = sample(SYN, length(which(SynForcng == "G")), prob = c(0.15, 0.1, 0.1, 0.25, 0.4), replace = TRUE)
SynForcng[SynForcng == "H"] = sample(SYN, length(which(SynForcng == "H")), prob = c(0.25, 0.25, 0.25, 0.15, 0.1), replace = TRUE)
SynForcng[SynForcng == "I"] = sample(SYN, length(which(SynForcng == "I")), prob = c(0.25, 0.2, 0.15, 0.2, 0.2), replace = TRUE)
SynForcng[SynForcng == "J"] = sample(SYN, length(which(SynForcng == "J")), prob = c(0.01, 0.05, 0.01, 0.05, 0.88), replace = TRUE)
SynForcng[SynForcng == "K"] = sample(SYN, length(which(SynForcng == "K")), prob = c(0.2, 0.2, 0.35, 0.15, 0.1), replace = TRUE)

MeanRH = Scenario
MeanRH[MeanRH == "A"] = sample(MOIST, length(which(MeanRH == "A")), prob = c(0.33, 0.5, 0.17), replace = TRUE)
MeanRH[MeanRH == "B"] = sample(MOIST, length(which(MeanRH == "B")), prob = c(0.4, 0.4, 0.2), replace = TRUE)
MeanRH[MeanRH == "C"] = sample(MOIST, length(which(MeanRH == "C")), prob = c(0.05, 0.45, 0.5), replace = TRUE)
MeanRH[MeanRH == "D"] = sample(MOIST, length(which(MeanRH == "D")), prob = c(0.1, 0.5, 0.4), replace = TRUE)
MeanRH[MeanRH == "E"] = sample(MOIST, length(which(MeanRH == "E")), prob = c(0.05, 0.65, 0.3), replace = TRUE)
MeanRH[MeanRH == "F"] = sample(MOIST, length(which(MeanRH == "F")), prob = c(1, 0, 0), replace = TRUE)
MeanRH[MeanRH == "G"] = sample(MOIST, length(which(MeanRH == "G")), prob = c(0, 0.07, 0.93), replace = TRUE)
MeanRH[MeanRH == "H"] = sample(MOIST, length(which(MeanRH == "H")), prob = c(0.4, 0.55, 0.05), replace = TRUE)
MeanRH[MeanRH == "I"] = sample(MOIST, length(which(MeanRH == "I")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
MeanRH[MeanRH == "J"] = sample(MOIST, length(which(MeanRH == "J")), prob = c(0.05, 0.55, 0.4), replace = TRUE)
MeanRH[MeanRH == "K"] = sample(MOIST, length(which(MeanRH == "K")), prob = c(0.2, 0.4, 0.4), replace = TRUE)

LowLLapse = Scenario
LowLLapse[LowLLapse == "A"] = sample(LL2, length(which(LowLLapse == "A")), prob = c(0.04, 0.25, 0.35, 0.36), replace = TRUE)
LowLLapse[LowLLapse == "B"] = sample(LL2, length(which(LowLLapse == "B")), prob = c(0.07, 0.31, 0.31, 0.31), replace = TRUE)
LowLLapse[LowLLapse == "C"] = sample(LL2, length(which(LowLLapse == "C")), prob = c(0.35, 0.47, 0.14, 0.04), replace = TRUE)
LowLLapse[LowLLapse == "D"] = sample(LL2, length(which(LowLLapse == "D")), prob = c(0.4, 0.4, 0.13, 0.07), replace = TRUE)
LowLLapse[LowLLapse == "E"] = sample(LL2, length(which(LowLLapse == "E")), prob = c(0.45, 0.35, 0.15, 0.05), replace = TRUE)
LowLLapse[LowLLapse == "F"] = sample(LL2, length(which(LowLLapse == "F")), prob = c(0.01, 0.35, 0.45, 0.19), replace = TRUE)
LowLLapse[LowLLapse == "G"] = sample(LL2, length(which(LowLLapse == "G")), prob = c(0.78, 0.19, 0.03, 0), replace = TRUE)
LowLLapse[LowLLapse == "H"] = sample(LL2, length(which(LowLLapse == "H")), prob = c(0, 0.02, 0.33, 0.65), replace = TRUE)
LowLLapse[LowLLapse == "I"] = sample(LL2, length(which(LowLLapse == "I")), prob = c(0.22, 0.4, 0.3, 0.08), replace = TRUE)
LowLLapse[LowLLapse == "J"] = sample(LL2, length(which(LowLLapse == "J")), prob = c(0.13, 0.4, 0.35, 0.12), replace = TRUE)
LowLLapse[LowLLapse == "K"] = sample(LL2, length(which(LowLLapse == "K")), prob = c(0.09, 0.4, 0.33, 0.18), replace = TRUE)

ScnRelPlFcst = Scenario

WindAloft = Scenario
WindAloft[WindAloft == "A"] = sample(WLOFT, length(which(WindAloft == "A")), prob = c(0, 0.95, 0.01, 0.04), replace = TRUE)
WindAloft[WindAloft == "B"] = sample(WLOFT, length(which(WindAloft == "B")), prob = c(0.2, 0.3, 0.2, 0.3), replace = TRUE)
WindAloft[WindAloft == "C"] = sample(WLOFT, length(which(WindAloft == "C")), prob = c(0.05, 0.09, 0.59, 0.27), replace = TRUE)
WindAloft[WindAloft == "D"] = sample(WLOFT, length(which(WindAloft == "D")), prob = c(0.03, 0.32, 0.42, 0.23), replace = TRUE)
WindAloft[WindAloft == "E"] = sample(WLOFT, length(which(WindAloft == "E")), prob = c(0.07, 0.66, 0.02, 0.25), replace = TRUE)
WindAloft[WindAloft == "F"] = sample(WLOFT, length(which(WindAloft == "F")), prob = c(0.5, 0, 0, 0.5), replace = TRUE)
WindAloft[WindAloft == "G"] = sample(WLOFT, length(which(WindAloft == "G")), prob = c(0.25, 0.3, 0.25, 0.2), replace = TRUE)
WindAloft[WindAloft == "H"] = sample(WLOFT, length(which(WindAloft == "H")), prob = c(0.2, 0.14, 0.43, 0.23), replace = TRUE)
WindAloft[WindAloft == "I"] = sample(WLOFT, length(which(WindAloft == "I")), prob = c(0.2, 0.41, 0.1, 0.29), replace = TRUE)
WindAloft[WindAloft == "J"] = sample(WLOFT, length(which(WindAloft == "J")), prob = c(0.96, 0, 0, 0.04), replace = TRUE)
WindAloft[WindAloft == "K"] = sample(WLOFT, length(which(WindAloft == "K")), prob = c(0.03, 0.08, 0.33, 0.56), replace = TRUE)

ScenRel34 = Scenario
ScenRel34[ScenRel34 == "A"] = sample(SC34, length(which(ScenRel34 == "A")), prob = c(1, 0, 0, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "B"] = sample(SC34, length(which(ScenRel34 == "B")), prob = c(0, 1, 0, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "C"] = sample(SC34, length(which(ScenRel34 == "C")), prob = c(1, 0, 0, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "D"] = sample(SC34, length(which(ScenRel34 == "D")), prob = c(0, 0, 1, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "E"] = sample(SC34, length(which(ScenRel34 == "E")), prob = c(1, 0, 0, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "F"] = sample(SC34, length(which(ScenRel34 == "F")), prob = c(1, 0, 0, 0, 0), replace = TRUE)
ScenRel34[ScenRel34 == "G"] = sample(SC34, length(which(ScenRel34 == "G")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
ScenRel34[ScenRel34 == "H"] = sample(SC34, length(which(ScenRel34 == "H")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
ScenRel34[ScenRel34 == "I"] = sample(SC34, length(which(ScenRel34 == "I")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
ScenRel34[ScenRel34 == "J"] = sample(SC34, length(which(ScenRel34 == "J")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
ScenRel34[ScenRel34 == "K"] = sample(SC34, length(which(ScenRel34 == "K")), prob = c(1, 0, 0, 0, 0), replace = TRUE)

AMCINInScen = apply(cbind(ScenRelAMCIN, MorningCIN), 1, paste, collapse = ":")
AMCINInScen[AMCINInScen == "AB:None"] = sample(AVE, length(which(AMCINInScen == "AB:None")), prob = c(1, 0, 0), replace = TRUE)
AMCINInScen[AMCINInScen == "AB:PartInhibit"] = sample(AVE, length(which(AMCINInScen == "AB:PartInhibit")), prob = c(0.6, 0.37, 0.03), replace = TRUE)
AMCINInScen[AMCINInScen == "AB:Stifling"] = sample(AVE, length(which(AMCINInScen == "AB:Stifling")), prob = c(0.25, 0.45, 0.3), replace = TRUE)
AMCINInScen[AMCINInScen == "AB:TotalInhibit"] = sample(AVE, length(which(AMCINInScen == "AB:TotalInhibit")), prob = c(0, 0.1, 0.9), replace = TRUE)
AMCINInScen[AMCINInScen == "CThruK:None"] = sample(AVE, length(which(AMCINInScen == "CThruK:None")), prob = c(0.75, 0.25, 0), replace = TRUE)
AMCINInScen[AMCINInScen == "CThruK:PartInhibit"] = sample(AVE, length(which(AMCINInScen == "CThruK:PartInhibit")), prob = c(0.3, 0.6, 0.1), replace = TRUE)
AMCINInScen[AMCINInScen == "CThruK:Stifling"] = sample(AVE, length(which(AMCINInScen == "CThruK:Stifling")), prob = c(0.01, 0.4, 0.59), replace = TRUE)
AMCINInScen[AMCINInScen == "CThruK:TotalInhibit"] = sample(AVE, length(which(AMCINInScen == "CThruK:TotalInhibit")), prob = c(0, 0.03, 0.97), replace = TRUE)

CurPropConv = apply(cbind(LatestCIN, LLIW), 1, paste, collapse = ":")
CurPropConv[CurPropConv == "None:Unfavorable"] = sample(STRENGTH2, length(which(CurPropConv == "None:Unfavorable")), prob = c(0.7, 0.28, 0.02, 0), replace = TRUE)
CurPropConv[CurPropConv == "None:Weak"] = sample(STRENGTH2, length(which(CurPropConv == "None:Weak")), prob = c(0.1, 0.5, 0.3, 0.1), replace = TRUE)
CurPropConv[CurPropConv == "None:Moderate"] = sample(STRENGTH2, length(which(CurPropConv == "None:Moderate")), prob = c(0.01, 0.14, 0.35, 0.5), replace = TRUE)
CurPropConv[CurPropConv == "None:Strong"] = sample(STRENGTH2, length(which(CurPropConv == "None:Strong")), prob = c(0, 0.02, 0.18, 0.8), replace = TRUE)
CurPropConv[CurPropConv == "PartInhibit:Unfavorable"] = sample(STRENGTH2, length(which(CurPropConv == "PartInhibit:Unfavorable")), prob = c(0.9, 0.09, 0.01, 0), replace = TRUE)
CurPropConv[CurPropConv == "PartInhibit:Weak"] = sample(STRENGTH2, length(which(CurPropConv == "PartInhibit:Weak")), prob = c(0.65, 0.25, 0.09, 0.01), replace = TRUE)
CurPropConv[CurPropConv == "PartInhibit:Moderate"] = sample(STRENGTH2, length(which(CurPropConv == "PartInhibit:Moderate")), prob = c(0.25, 0.35, 0.3, 0.1), replace = TRUE)
CurPropConv[CurPropConv == "PartInhibit:Strong"] = sample(STRENGTH2, length(which(CurPropConv == "PartInhibit:Strong")), prob = c(0.01, 0.15, 0.33, 0.51), replace = TRUE)
CurPropConv[CurPropConv == "Stifling:Unfavorable"] = sample(STRENGTH2, length(which(CurPropConv == "Stifling:Unfavorable")), prob = c(0.95, 0.05, 0, 0), replace = TRUE)
CurPropConv[CurPropConv == "Stifling:Weak"] = sample(STRENGTH2, length(which(CurPropConv == "Stifling:Weak")), prob = c(0.75, 0.23, 0.02, 0), replace = TRUE)
CurPropConv[CurPropConv == "Stifling:Moderate"] = sample(STRENGTH2, length(which(CurPropConv == "Stifling:Moderate")), prob = c(0.4, 0.4, 0.18, 0.02), replace = TRUE)
CurPropConv[CurPropConv == "Stifling:Strong"] = sample(STRENGTH2, length(which(CurPropConv == "Stifling:Strong")), prob = c(0.2, 0.3, 0.35, 0.15), replace = TRUE)
CurPropConv[CurPropConv == "TotalInhibit:Unfavorable"] = sample(STRENGTH2, length(which(CurPropConv == "TotalInhibit:Unfavorable")), prob = c(1, 0, 0, 0), replace = TRUE)
CurPropConv[CurPropConv == "TotalInhibit:Weak"] = sample(STRENGTH2, length(which(CurPropConv == "TotalInhibit:Weak")), prob = c(0.95, 0.05, 0, 0), replace = TRUE)
CurPropConv[CurPropConv == "TotalInhibit:Moderate"] = sample(STRENGTH2, length(which(CurPropConv == "TotalInhibit:Moderate")), prob = c(0.75, 0.2, 0.05, 0), replace = TRUE)
CurPropConv[CurPropConv == "TotalInhibit:Strong"] = sample(STRENGTH2, length(which(CurPropConv == "TotalInhibit:Strong")), prob = c(0.5, 0.35, 0.1, 0.05), replace = TRUE)

CombClouds = apply(cbind(VISCloudCov, IRCloudCover), 1, paste, collapse = ":")
CombClouds[CombClouds == "Cloudy:Cloudy"] = sample(CLOUDY, length(which(CombClouds == "Cloudy:Cloudy")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
CombClouds[CombClouds == "Cloudy:PC"] = sample(CLOUDY, length(which(CombClouds == "Cloudy:PC")), prob = c(0.85, 0.13, 0.02), replace = TRUE)
CombClouds[CombClouds == "Cloudy:Clear"] = sample(CLOUDY, length(which(CombClouds == "Cloudy:Clear")), prob = c(0.8, 0.1, 0.1), replace = TRUE)
CombClouds[CombClouds == "PC:Cloudy"] = sample(CLOUDY, length(which(CombClouds == "PC:Cloudy")), prob = c(0.45, 0.52, 0.03), replace = TRUE)
CombClouds[CombClouds == "PC:PC"] = sample(CLOUDY, length(which(CombClouds == "PC:PC")), prob = c(0.1, 0.8, 0.1), replace = TRUE)
CombClouds[CombClouds == "PC:Clear"] = sample(CLOUDY, length(which(CombClouds == "PC:Clear")), prob = c(0.05, 0.45, 0.5), replace = TRUE)
CombClouds[CombClouds == "Clear:Cloudy"] = sample(CLOUDY, length(which(CombClouds == "Clear:Cloudy")), prob = c(0.1, 0.4, 0.5), replace = TRUE)
CombClouds[CombClouds == "Clear:PC"] = sample(CLOUDY, length(which(CombClouds == "Clear:PC")), prob = c(0.02, 0.28, 0.7), replace = TRUE)
CombClouds[CombClouds == "Clear:Clear"] = sample(CLOUDY, length(which(CombClouds == "Clear:Clear")), prob = c(0, 0.02, 0.98), replace = TRUE)

CombVerMo = apply(cbind(N07muVerMo, SubjVertMo, QGVertMotion), 1, paste, collapse = ":")
CombVerMo[CombVerMo == "StrongUp:StrongUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:StrongUp:StrongUp")), prob = c(1, 0, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:StrongUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:StrongUp:WeakUp")), prob = c(0.9, 0.1, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:StrongUp:Neutral"] = sample(VERT, length(which(CombVerMo == "StrongUp:StrongUp:Neutral")), prob = c(0.7, 0.2, 0.1, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:StrongUp:Down"] = sample(VERT, length(which(CombVerMo == "StrongUp:StrongUp:Down")), prob = c(0.2, 0.5, 0.2, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:WeakUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:WeakUp:StrongUp")), prob = c(0.9, 0.1, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:WeakUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:WeakUp:WeakUp")), prob = c(0.7, 0.3, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:WeakUp:Neutral"] = sample(VERT, length(which(CombVerMo == "StrongUp:WeakUp:Neutral")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:WeakUp:Down"] = sample(VERT, length(which(CombVerMo == "StrongUp:WeakUp:Down")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Neutral:StrongUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:Neutral:StrongUp")), prob = c(0.7, 0.2, 0.1, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Neutral:WeakUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:Neutral:WeakUp")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Neutral:Neutral"] = sample(VERT, length(which(CombVerMo == "StrongUp:Neutral:Neutral")), prob = c(0.2, 0.6, 0.2, 0), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Neutral:Down"] = sample(VERT, length(which(CombVerMo == "StrongUp:Neutral:Down")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Down:StrongUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:Down:StrongUp")), prob = c(0.2, 0.5, 0.2, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Down:WeakUp"] = sample(VERT, length(which(CombVerMo == "StrongUp:Down:WeakUp")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Down:Neutral"] = sample(VERT, length(which(CombVerMo == "StrongUp:Down:Neutral")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "StrongUp:Down:Down"] = sample(VERT, length(which(CombVerMo == "StrongUp:Down:Down")), prob = c(0.1, 0.1, 0.2, 0.6), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:StrongUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:StrongUp:StrongUp")), prob = c(0.9, 0.1, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:StrongUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:StrongUp:WeakUp")), prob = c(0.7, 0.3, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:StrongUp:Neutral"] = sample(VERT, length(which(CombVerMo == "WeakUp:StrongUp:Neutral")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:StrongUp:Down"] = sample(VERT, length(which(CombVerMo == "WeakUp:StrongUp:Down")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:WeakUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:WeakUp:StrongUp")), prob = c(0.7, 0.3, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:WeakUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:WeakUp:WeakUp")), prob = c(0, 1, 0, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:WeakUp:Neutral"] = sample(VERT, length(which(CombVerMo == "WeakUp:WeakUp:Neutral")), prob = c(0, 0.7, 0.3, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:WeakUp:Down"] = sample(VERT, length(which(CombVerMo == "WeakUp:WeakUp:Down")), prob = c(0, 0.2, 0.7, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Neutral:StrongUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:Neutral:StrongUp")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Neutral:WeakUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:Neutral:WeakUp")), prob = c(0, 0.7, 0.3, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Neutral:Neutral"] = sample(VERT, length(which(CombVerMo == "WeakUp:Neutral:Neutral")), prob = c(0, 0.3, 0.7, 0), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Neutral:Down"] = sample(VERT, length(which(CombVerMo == "WeakUp:Neutral:Down")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Down:StrongUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:Down:StrongUp")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Down:WeakUp"] = sample(VERT, length(which(CombVerMo == "WeakUp:Down:WeakUp")), prob = c(0, 0.2, 0.7, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Down:Neutral"] = sample(VERT, length(which(CombVerMo == "WeakUp:Down:Neutral")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "WeakUp:Down:Down"] = sample(VERT, length(which(CombVerMo == "WeakUp:Down:Down")), prob = c(0, 0.1, 0.2, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:StrongUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "Neutral:StrongUp:StrongUp")), prob = c(0.7, 0.2, 0.1, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:StrongUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "Neutral:StrongUp:WeakUp")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:StrongUp:Neutral"] = sample(VERT, length(which(CombVerMo == "Neutral:StrongUp:Neutral")), prob = c(0.2, 0.6, 0.2, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:StrongUp:Down"] = sample(VERT, length(which(CombVerMo == "Neutral:StrongUp:Down")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:WeakUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "Neutral:WeakUp:StrongUp")), prob = c(0.15, 0.7, 0.15, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:WeakUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "Neutral:WeakUp:WeakUp")), prob = c(0, 0.7, 0.3, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:WeakUp:Neutral"] = sample(VERT, length(which(CombVerMo == "Neutral:WeakUp:Neutral")), prob = c(0, 0.3, 0.7, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:WeakUp:Down"] = sample(VERT, length(which(CombVerMo == "Neutral:WeakUp:Down")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Neutral:StrongUp"] = sample(VERT, length(which(CombVerMo == "Neutral:Neutral:StrongUp")), prob = c(0.2, 0.6, 0.2, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Neutral:WeakUp"] = sample(VERT, length(which(CombVerMo == "Neutral:Neutral:WeakUp")), prob = c(0, 0.3, 0.7, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Neutral:Neutral"] = sample(VERT, length(which(CombVerMo == "Neutral:Neutral:Neutral")), prob = c(0, 0, 1, 0), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Neutral:Down"] = sample(VERT, length(which(CombVerMo == "Neutral:Neutral:Down")), prob = c(0, 0, 0.7, 0.3), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Down:StrongUp"] = sample(VERT, length(which(CombVerMo == "Neutral:Down:StrongUp")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Down:WeakUp"] = sample(VERT, length(which(CombVerMo == "Neutral:Down:WeakUp")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Down:Neutral"] = sample(VERT, length(which(CombVerMo == "Neutral:Down:Neutral")), prob = c(0, 0, 0.7, 0.3), replace = TRUE)
CombVerMo[CombVerMo == "Neutral:Down:Down"] = sample(VERT, length(which(CombVerMo == "Neutral:Down:Down")), prob = c(0, 0, 0.3, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Down:StrongUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "Down:StrongUp:StrongUp")), prob = c(0.2, 0.5, 0.2, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:StrongUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "Down:StrongUp:WeakUp")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:StrongUp:Neutral"] = sample(VERT, length(which(CombVerMo == "Down:StrongUp:Neutral")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:StrongUp:Down"] = sample(VERT, length(which(CombVerMo == "Down:StrongUp:Down")), prob = c(0.1, 0.1, 0.2, 0.6), replace = TRUE)
CombVerMo[CombVerMo == "Down:WeakUp:StrongUp"] = sample(VERT, length(which(CombVerMo == "Down:WeakUp:StrongUp")), prob = c(0.1, 0.35, 0.45, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:WeakUp:WeakUp"] = sample(VERT, length(which(CombVerMo == "Down:WeakUp:WeakUp")), prob = c(0, 0.2, 0.7, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:WeakUp:Neutral"] = sample(VERT, length(which(CombVerMo == "Down:WeakUp:Neutral")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "Down:WeakUp:Down"] = sample(VERT, length(which(CombVerMo == "Down:WeakUp:Down")), prob = c(0, 0.1, 0.2, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Down:Neutral:StrongUp"] = sample(VERT, length(which(CombVerMo == "Down:Neutral:StrongUp")), prob = c(0.1, 0.2, 0.6, 0.1), replace = TRUE)
CombVerMo[CombVerMo == "Down:Neutral:WeakUp"] = sample(VERT, length(which(CombVerMo == "Down:Neutral:WeakUp")), prob = c(0, 0.15, 0.5, 0.35), replace = TRUE)
CombVerMo[CombVerMo == "Down:Neutral:Neutral"] = sample(VERT, length(which(CombVerMo == "Down:Neutral:Neutral")), prob = c(0, 0, 0.7, 0.3), replace = TRUE)
CombVerMo[CombVerMo == "Down:Neutral:Down"] = sample(VERT, length(which(CombVerMo == "Down:Neutral:Down")), prob = c(0, 0, 0.3, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Down:Down:StrongUp"] = sample(VERT, length(which(CombVerMo == "Down:Down:StrongUp")), prob = c(0.1, 0.1, 0.2, 0.6), replace = TRUE)
CombVerMo[CombVerMo == "Down:Down:WeakUp"] = sample(VERT, length(which(CombVerMo == "Down:Down:WeakUp")), prob = c(0, 0.1, 0.2, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Down:Down:Neutral"] = sample(VERT, length(which(CombVerMo == "Down:Down:Neutral")), prob = c(0, 0, 0.3, 0.7), replace = TRUE)
CombVerMo[CombVerMo == "Down:Down:Down"] = sample(VERT, length(which(CombVerMo == "Down:Down:Down")), prob = c(0, 0, 0, 1), replace = TRUE)

AreaMesoALS = CombVerMo

CombMoisture = apply(cbind(SatContMoist, RaoContMoist), 1, paste, collapse = ":")
CombMoisture[CombMoisture == "VeryWet:VeryWet"] = sample(WET, length(which(CombMoisture == "VeryWet:VeryWet")), prob = c(0.9, 0.1, 0, 0), replace = TRUE)
CombMoisture[CombMoisture == "VeryWet:Wet"] = sample(WET, length(which(CombMoisture == "VeryWet:Wet")), prob = c(0.6, 0.35, 0.05, 0), replace = TRUE)
CombMoisture[CombMoisture == "VeryWet:Neutral"] = sample(WET, length(which(CombMoisture == "VeryWet:Neutral")), prob = c(0.3, 0.5, 0.2, 0), replace = TRUE)
CombMoisture[CombMoisture == "VeryWet:Dry"] = sample(WET, length(which(CombMoisture == "VeryWet:Dry")), prob = c(0.25, 0.35, 0.25, 0.15), replace = TRUE)
CombMoisture[CombMoisture == "Wet:VeryWet"] = sample(WET, length(which(CombMoisture == "Wet:VeryWet")), prob = c(0.55, 0.4, 0.05, 0), replace = TRUE)
CombMoisture[CombMoisture == "Wet:Wet"] = sample(WET, length(which(CombMoisture == "Wet:Wet")), prob = c(0.15, 0.6, 0.2, 0.05), replace = TRUE)
CombMoisture[CombMoisture == "Wet:Neutral"] = sample(WET, length(which(CombMoisture == "Wet:Neutral")), prob = c(0.05, 0.4, 0.45, 0.1), replace = TRUE)
CombMoisture[CombMoisture == "Wet:Dry"] = sample(WET, length(which(CombMoisture == "Wet:Dry")), prob = c(0.1, 0.3, 0.3, 0.3), replace = TRUE)
CombMoisture[CombMoisture == "Neutral:VeryWet"] = sample(WET, length(which(CombMoisture == "Neutral:VeryWet")), prob = c(0.25, 0.3, 0.35, 0.1), replace = TRUE)
CombMoisture[CombMoisture == "Neutral:Wet"] = sample(WET, length(which(CombMoisture == "Neutral:Wet")), prob = c(0.1, 0.35, 0.5, 0.05), replace = TRUE)
CombMoisture[CombMoisture == "Neutral:Neutral"] = sample(WET, length(which(CombMoisture == "Neutral:Neutral")), prob = c(0, 0.15, 0.7, 0.15), replace = TRUE)
CombMoisture[CombMoisture == "Neutral:Dry"] = sample(WET, length(which(CombMoisture == "Neutral:Dry")), prob = c(0, 0.1, 0.4, 0.5), replace = TRUE)
CombMoisture[CombMoisture == "Dry:VeryWet"] = sample(WET, length(which(CombMoisture == "Dry:VeryWet")), prob = c(0.25, 0.25, 0.25, 0.25), replace = TRUE)
CombMoisture[CombMoisture == "Dry:Wet"] = sample(WET, length(which(CombMoisture == "Dry:Wet")), prob = c(0.25, 0.25, 0.25, 0.25), replace = TRUE)
CombMoisture[CombMoisture == "Dry:Neutral"] = sample(WET, length(which(CombMoisture == "Dry:Neutral")), prob = c(0.25, 0.25, 0.25, 0.25), replace = TRUE)
CombMoisture[CombMoisture == "Dry:Dry"] = sample(WET, length(which(CombMoisture == "Dry:Dry")), prob = c(0.25, 0.25, 0.25, 0.25), replace = TRUE)


AreaMoDryAir = apply(cbind(AreaMesoALS, CombMoisture), 1, paste, collapse = ":")
AreaMoDryAir[AreaMoDryAir == "StrongUp:VeryWet"] = sample(WET, length(which(AreaMoDryAir == "StrongUp:VeryWet")), prob = c(0.99, 0.01, 0, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "StrongUp:Wet"] = sample(WET, length(which(AreaMoDryAir == "StrongUp:Wet")), prob = c(0.7, 0.29, 0.01, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "StrongUp:Neutral"] = sample(WET, length(which(AreaMoDryAir == "StrongUp:Neutral")), prob = c(0.2, 0.55, 0.24, 0.01), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "StrongUp:Dry"] = sample(WET, length(which(AreaMoDryAir == "StrongUp:Dry")), prob = c(0, 0.25, 0.55, 0.2), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "WeakUp:VeryWet"] = sample(WET, length(which(AreaMoDryAir == "WeakUp:VeryWet")), prob = c(0.8, 0.2, 0, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "WeakUp:Wet"] = sample(WET, length(which(AreaMoDryAir == "WeakUp:Wet")), prob = c(0.35, 0.55, 0.1, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "WeakUp:Neutral"] = sample(WET, length(which(AreaMoDryAir == "WeakUp:Neutral")), prob = c(0.01, 0.39, 0.55, 0.05), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "WeakUp:Dry"] = sample(WET, length(which(AreaMoDryAir == "WeakUp:Dry")), prob = c(0, 0.02, 0.43, 0.55), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Neutral:VeryWet"] = sample(WET, length(which(AreaMoDryAir == "Neutral:VeryWet")), prob = c(0.7, 0.29, 0.01, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Neutral:Wet"] = sample(WET, length(which(AreaMoDryAir == "Neutral:Wet")), prob = c(0.2, 0.6, 0.2, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Neutral:Neutral"] = sample(WET, length(which(AreaMoDryAir == "Neutral:Neutral")), prob = c(0.01, 0.09, 0.8, 0.1), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Neutral:Dry"] = sample(WET, length(which(AreaMoDryAir == "Neutral:Dry")), prob = c(0, 0, 0.3, 0.7), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Down:VeryWet"] = sample(WET, length(which(AreaMoDryAir == "Down:VeryWet")), prob = c(0.2, 0.74, 0.06, 0), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Down:Wet"] = sample(WET, length(which(AreaMoDryAir == "Down:Wet")), prob = c(0.05, 0.4, 0.45, 0.1), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Down:Neutral"] = sample(WET, length(which(AreaMoDryAir == "Down:Neutral")), prob = c(0, 0.05, 0.5, 0.45), replace = TRUE)
AreaMoDryAir[AreaMoDryAir == "Down:Dry"] = sample(WET, length(which(AreaMoDryAir == "Down:Dry")), prob = c(0, 0, 0.01, 0.99), replace = TRUE)

CldShadeOth = apply(cbind(AreaMoDryAir, AreaMesoALS, CombClouds), 1, paste, collapse = ":")
CldShadeOth[CldShadeOth == "VeryWet:StrongUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:StrongUp:Cloudy")), prob = c(1, 0, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:StrongUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:StrongUp:PC")), prob = c(0.85, 0.15, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:StrongUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:StrongUp:Clear")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:WeakUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:WeakUp:Cloudy")), prob = c(0.95, 0.05, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:WeakUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:WeakUp:PC")), prob = c(0.4, 0.55, 0.05), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:WeakUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:WeakUp:Clear")), prob = c(0.05, 0.45, 0.5), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Neutral:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Neutral:Cloudy")), prob = c(0.93, 0.07, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Neutral:PC"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Neutral:PC")), prob = c(0.2, 0.78, 0.02), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Neutral:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Neutral:Clear")), prob = c(0.01, 0.29, 0.7), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Down:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Down:Cloudy")), prob = c(0.74, 0.25, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Down:PC"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Down:PC")), prob = c(0, 0.5, 0.5), replace = TRUE)
CldShadeOth[CldShadeOth == "VeryWet:Down:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "VeryWet:Down:Clear")), prob = c(0, 0.1, 0.9), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:StrongUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:StrongUp:Cloudy")), prob = c(0.92, 0.08, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:StrongUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:StrongUp:PC")), prob = c(0.7, 0.29, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:StrongUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:StrongUp:Clear")), prob = c(0.15, 0.4, 0.45), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:WeakUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:WeakUp:Cloudy")), prob = c(0.9, 0.09, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:WeakUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:WeakUp:PC")), prob = c(0.25, 0.6, 0.15), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:WeakUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:WeakUp:Clear")), prob = c(0.01, 0.3, 0.69), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Neutral:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Neutral:Cloudy")), prob = c(0.8, 0.2, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Neutral:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Neutral:PC")), prob = c(0.01, 0.89, 0.1), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Neutral:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Neutral:Clear")), prob = c(0, 0.1, 0.9), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Down:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Down:Cloudy")), prob = c(0.65, 0.34, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Down:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Down:PC")), prob = c(0, 0.4, 0.6), replace = TRUE)
CldShadeOth[CldShadeOth == "Wet:Down:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Wet:Down:Clear")), prob = c(0, 0.02, 0.98), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:StrongUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:StrongUp:Cloudy")), prob = c(0.88, 0.12, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:StrongUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:StrongUp:PC")), prob = c(0.4, 0.5, 0.1), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:StrongUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:StrongUp:Clear")), prob = c(0.1, 0.4, 0.5), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:WeakUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:WeakUp:Cloudy")), prob = c(0.85, 0.15, 0), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:WeakUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:WeakUp:PC")), prob = c(0.15, 0.75, 0.1), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:WeakUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:WeakUp:Clear")), prob = c(0, 0.2, 0.8), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Neutral:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Neutral:Cloudy")), prob = c(0.8, 0.18, 0.02), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Neutral:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Neutral:PC")), prob = c(0.03, 0.85, 0.12), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Neutral:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Neutral:Clear")), prob = c(0, 0.05, 0.95), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Down:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Down:Cloudy")), prob = c(0.5, 0.48, 0.02), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Down:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Down:PC")), prob = c(0.01, 0.74, 0.25), replace = TRUE)
CldShadeOth[CldShadeOth == "Neutral:Down:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Neutral:Down:Clear")), prob = c(0, 0.01, 0.99), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:StrongUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:StrongUp:Cloudy")), prob = c(0.85, 0.14, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:StrongUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:StrongUp:PC")), prob = c(0.55, 0.43, 0.02), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:StrongUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:StrongUp:Clear")), prob = c(0.1, 0.25, 0.65), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:WeakUp:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:WeakUp:Cloudy")), prob = c(0.6, 0.39, 0.01), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:WeakUp:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:WeakUp:PC")), prob = c(0.01, 0.9, 0.09), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:WeakUp:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:WeakUp:Clear")), prob = c(0, 0.15, 0.85), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Neutral:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Neutral:Cloudy")), prob = c(0.78, 0.2, 0.02), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Neutral:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Neutral:PC")), prob = c(0.01, 0.74, 0.25), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Neutral:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Neutral:Clear")), prob = c(0, 0.04, 0.96), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Down:Cloudy"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Down:Cloudy")), prob = c(0.42, 0.55, 0.03), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Down:PC"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Down:PC")), prob = c(0.05, 0.65, 0.3), replace = TRUE)
CldShadeOth[CldShadeOth == "Dry:Down:Clear"] = sample(CLOUDY, length(which(CldShadeOth == "Dry:Down:Clear")), prob = c(0, 0, 1), replace = TRUE)


InsInMt = apply(cbind(CldShadeOth, AMInstabMt), 1, paste, collapse = ":")
InsInMt[InsInMt == "Cloudy:None"] = sample(STRENGTH, length(which(InsInMt == "Cloudy:None")), prob = c(0.9, 0.1, 0), replace = TRUE)
InsInMt[InsInMt == "Cloudy:Weak"] = sample(STRENGTH, length(which(InsInMt == "Cloudy:Weak")), prob = c(0.01, 0.4, 0.59), replace = TRUE)
InsInMt[InsInMt == "Cloudy:Strong"] = sample(STRENGTH, length(which(InsInMt == "Cloudy:Strong")), prob = c(0, 0.05, 0.95), replace = TRUE)
InsInMt[InsInMt == "PC:None"] = sample(STRENGTH, length(which(InsInMt == "PC:None")), prob = c(0.6, 0.39, 0.01), replace = TRUE)
InsInMt[InsInMt == "PC:Weak"] = sample(STRENGTH, length(which(InsInMt == "PC:Weak")), prob = c(0, 0.4, 0.6), replace = TRUE)
InsInMt[InsInMt == "PC:Strong"] = sample(STRENGTH, length(which(InsInMt == "PC:Strong")), prob = c(0, 0, 1), replace = TRUE)
InsInMt[InsInMt == "Clear:None"] = sample(STRENGTH, length(which(InsInMt == "Clear:None")), prob = c(0.5, 0.35, 0.15), replace = TRUE)
InsInMt[InsInMt == "Clear:Weak"] = sample(STRENGTH, length(which(InsInMt == "Clear:Weak")), prob = c(0, 0.15, 0.85), replace = TRUE)
InsInMt[InsInMt == "Clear:Strong"] = sample(STRENGTH, length(which(InsInMt == "Clear:Strong")), prob = c(0, 0, 1), replace = TRUE)

CldShadeConv = apply(cbind(InsInMt, WndHodograph), 1, paste, collapse = ":")
CldShadeConv[CldShadeConv == "None:DCVZFavor"] = sample(SHADE, length(which(CldShadeConv == "None:DCVZFavor")), prob = c(1, 0, 0), replace = TRUE)
CldShadeConv[CldShadeConv == "None:StrongWest"] = sample(SHADE, length(which(CldShadeConv == "None:StrongWest")), prob = c(1, 0, 0), replace = TRUE)
CldShadeConv[CldShadeConv == "None:Westerly"] = sample(SHADE, length(which(CldShadeConv == "None:Westerly")), prob = c(1, 0, 0), replace = TRUE)
CldShadeConv[CldShadeConv == "None:Other"] = sample(SHADE, length(which(CldShadeConv == "None:Other")), prob = c(1, 0, 0), replace = TRUE)
CldShadeConv[CldShadeConv == "Weak:DCVZFavor"] = sample(SHADE, length(which(CldShadeConv == "Weak:DCVZFavor")), prob = c(0.3, 0.6, 0.1), replace = TRUE)
CldShadeConv[CldShadeConv == "Weak:StrongWest"] = sample(SHADE, length(which(CldShadeConv == "Weak:StrongWest")), prob = c(0.2, 0.7, 0.1), replace = TRUE)
CldShadeConv[CldShadeConv == "Weak:Westerly"] = sample(SHADE, length(which(CldShadeConv == "Weak:Westerly")), prob = c(0.5, 0.46, 0.04), replace = TRUE)
CldShadeConv[CldShadeConv == "Weak:Other"] = sample(SHADE, length(which(CldShadeConv == "Weak:Other")), prob = c(0.8, 0.19, 0.01), replace = TRUE)
CldShadeConv[CldShadeConv == "Strong:DCVZFavor"] = sample(SHADE, length(which(CldShadeConv == "Strong:DCVZFavor")), prob = c(0, 0.3, 0.7), replace = TRUE)
CldShadeConv[CldShadeConv == "Strong:StrongWest"] = sample(SHADE, length(which(CldShadeConv == "Strong:StrongWest")), prob = c(0, 0.2, 0.8), replace = TRUE)
CldShadeConv[CldShadeConv == "Strong:Westerly"] = sample(SHADE, length(which(CldShadeConv == "Strong:Westerly")), prob = c(0.1, 0.5, 0.4), replace = TRUE)
CldShadeConv[CldShadeConv == "Strong:Other"] = sample(SHADE, length(which(CldShadeConv == "Strong:Other")), prob = c(0.5, 0.38, 0.12), replace = TRUE)

OutflowFrMt = apply(cbind(InsInMt, WndHodograph), 1, paste, collapse = ":")
OutflowFrMt[OutflowFrMt == "None:DCVZFavor"] = sample(STRENGTH, length(which(OutflowFrMt == "None:DCVZFavor")), prob = c(1, 0, 0), replace = TRUE)
OutflowFrMt[OutflowFrMt == "None:StrongWest"] = sample(STRENGTH, length(which(OutflowFrMt == "None:StrongWest")), prob = c(1, 0, 0), replace = TRUE)
OutflowFrMt[OutflowFrMt == "None:Westerly"] = sample(STRENGTH, length(which(OutflowFrMt == "None:Westerly")), prob = c(1, 0, 0), replace = TRUE)
OutflowFrMt[OutflowFrMt == "None:Other"] = sample(STRENGTH, length(which(OutflowFrMt == "None:Other")), prob = c(1, 0, 0), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Weak:DCVZFavor"] = sample(STRENGTH, length(which(OutflowFrMt == "Weak:DCVZFavor")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Weak:StrongWest"] = sample(STRENGTH, length(which(OutflowFrMt == "Weak:StrongWest")), prob = c(0.15, 0.4, 0.45), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Weak:Westerly"] = sample(STRENGTH, length(which(OutflowFrMt == "Weak:Westerly")), prob = c(0.35, 0.6, 0.05), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Weak:Other"] = sample(STRENGTH, length(which(OutflowFrMt == "Weak:Other")), prob = c(0.8, 0.19, 0.01), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Strong:DCVZFavor"] = sample(STRENGTH, length(which(OutflowFrMt == "Strong:DCVZFavor")), prob = c(0.05, 0.45, 0.5), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Strong:StrongWest"] = sample(STRENGTH, length(which(OutflowFrMt == "Strong:StrongWest")), prob = c(0.01, 0.15, 0.84), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Strong:Westerly"] = sample(STRENGTH, length(which(OutflowFrMt == "Strong:Westerly")), prob = c(0.1, 0.25, 0.65), replace = TRUE)
OutflowFrMt[OutflowFrMt == "Strong:Other"] = sample(STRENGTH, length(which(OutflowFrMt == "Strong:Other")), prob = c(0.6, 0.3, 0.1), replace = TRUE)

MountainFcst = InsInMt
MountainFcst[MountainFcst == "None"] = sample(FCST2, length(which(MountainFcst == "None")), prob = c(1, 0, 0), replace = TRUE)
MountainFcst[MountainFcst == "Weak"] = sample(FCST2, length(which(MountainFcst == "Weak")), prob = c(0.48, 0.5, 0.02), replace = TRUE)
MountainFcst[MountainFcst == "Strong"] = sample(FCST2, length(which(MountainFcst == "Strong")), prob = c(0.2, 0.5, 0.3), replace = TRUE)

Boundaries = apply(cbind(OutflowFrMt, WndHodograph, MorningBound), 1, paste, collapse = ":")
Boundaries[Boundaries == "None:DCVZFavor:None"] = sample(STRENGTH, length(which(Boundaries == "None:DCVZFavor:None")), prob = c(0.5, 0.48, 0.02), replace = TRUE)
Boundaries[Boundaries == "None:DCVZFavor:Weak"] = sample(STRENGTH, length(which(Boundaries == "None:DCVZFavor:Weak")), prob = c(0.3, 0.5, 0.2), replace = TRUE)
Boundaries[Boundaries == "None:DCVZFavor:Strong"] = sample(STRENGTH, length(which(Boundaries == "None:DCVZFavor:Strong")), prob = c(0.1, 0.25, 0.65), replace = TRUE)
Boundaries[Boundaries == "None:StrongWest:None"] = sample(STRENGTH, length(which(Boundaries == "None:StrongWest:None")), prob = c(0.75, 0.22, 0.03), replace = TRUE)
Boundaries[Boundaries == "None:StrongWest:Weak"] = sample(STRENGTH, length(which(Boundaries == "None:StrongWest:Weak")), prob = c(0.45, 0.45, 0.1), replace = TRUE)
Boundaries[Boundaries == "None:StrongWest:Strong"] = sample(STRENGTH, length(which(Boundaries == "None:StrongWest:Strong")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
Boundaries[Boundaries == "None:Westerly:None"] = sample(STRENGTH, length(which(Boundaries == "None:Westerly:None")), prob = c(0.8, 0.18, 0.02), replace = TRUE)
Boundaries[Boundaries == "None:Westerly:Weak"] = sample(STRENGTH, length(which(Boundaries == "None:Westerly:Weak")), prob = c(0.35, 0.5, 0.15), replace = TRUE)
Boundaries[Boundaries == "None:Westerly:Strong"] = sample(STRENGTH, length(which(Boundaries == "None:Westerly:Strong")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
Boundaries[Boundaries == "None:Other:None"] = sample(STRENGTH, length(which(Boundaries == "None:Other:None")), prob = c(0.7, 0.28, 0.02), replace = TRUE)
Boundaries[Boundaries == "None:Other:Weak"] = sample(STRENGTH, length(which(Boundaries == "None:Other:Weak")), prob = c(0.25, 0.6, 0.15), replace = TRUE)
Boundaries[Boundaries == "None:Other:Strong"] = sample(STRENGTH, length(which(Boundaries == "None:Other:Strong")), prob = c(0.05, 0.35, 0.6), replace = TRUE)
Boundaries[Boundaries == "Weak:DCVZFavor:None"] = sample(STRENGTH, length(which(Boundaries == "Weak:DCVZFavor:None")), prob = c(0.3, 0.63, 0.07), replace = TRUE)
Boundaries[Boundaries == "Weak:DCVZFavor:Weak"] = sample(STRENGTH, length(which(Boundaries == "Weak:DCVZFavor:Weak")), prob = c(0.1, 0.5, 0.4), replace = TRUE)
Boundaries[Boundaries == "Weak:DCVZFavor:Strong"] = sample(STRENGTH, length(which(Boundaries == "Weak:DCVZFavor:Strong")), prob = c(0.05, 0.2, 0.75), replace = TRUE)
Boundaries[Boundaries == "Weak:StrongWest:None"] = sample(STRENGTH, length(which(Boundaries == "Weak:StrongWest:None")), prob = c(0.15, 0.7, 0.15), replace = TRUE)
Boundaries[Boundaries == "Weak:StrongWest:Weak"] = sample(STRENGTH, length(which(Boundaries == "Weak:StrongWest:Weak")), prob = c(0.1, 0.75, 0.15), replace = TRUE)
Boundaries[Boundaries == "Weak:StrongWest:Strong"] = sample(STRENGTH, length(which(Boundaries == "Weak:StrongWest:Strong")), prob = c(0.05, 0.5, 0.45), replace = TRUE)
Boundaries[Boundaries == "Weak:Westerly:None"] = sample(STRENGTH, length(which(Boundaries == "Weak:Westerly:None")), prob = c(0.15, 0.7, 0.15), replace = TRUE)
Boundaries[Boundaries == "Weak:Westerly:Weak"] = sample(STRENGTH, length(which(Boundaries == "Weak:Westerly:Weak")), prob = c(0.05, 0.8, 0.15), replace = TRUE)
Boundaries[Boundaries == "Weak:Westerly:Strong"] = sample(STRENGTH, length(which(Boundaries == "Weak:Westerly:Strong")), prob = c(0.05, 0.45, 0.5), replace = TRUE)
Boundaries[Boundaries == "Weak:Other:None"] = sample(STRENGTH, length(which(Boundaries == "Weak:Other:None")), prob = c(0.4, 0.55, 0.05), replace = TRUE)
Boundaries[Boundaries == "Weak:Other:Weak"] = sample(STRENGTH, length(which(Boundaries == "Weak:Other:Weak")), prob = c(0.2, 0.65, 0.15), replace = TRUE)
Boundaries[Boundaries == "Weak:Other:Strong"] = sample(STRENGTH, length(which(Boundaries == "Weak:Other:Strong")), prob = c(0.05, 0.3, 0.65), replace = TRUE)
Boundaries[Boundaries == "Strong:DCVZFavor:None"] = sample(STRENGTH, length(which(Boundaries == "Strong:DCVZFavor:None")), prob = c(0, 0.55, 0.45), replace = TRUE)
Boundaries[Boundaries == "Strong:DCVZFavor:Weak"] = sample(STRENGTH, length(which(Boundaries == "Strong:DCVZFavor:Weak")), prob = c(0, 0.4, 0.6), replace = TRUE)
Boundaries[Boundaries == "Strong:DCVZFavor:Strong"] = sample(STRENGTH, length(which(Boundaries == "Strong:DCVZFavor:Strong")), prob = c(0, 0.15, 0.85), replace = TRUE)
Boundaries[Boundaries == "Strong:StrongWest:None"] = sample(STRENGTH, length(which(Boundaries == "Strong:StrongWest:None")), prob = c(0, 0.5, 0.5), replace = TRUE)
Boundaries[Boundaries == "Strong:StrongWest:Weak"] = sample(STRENGTH, length(which(Boundaries == "Strong:StrongWest:Weak")), prob = c(0, 0.4, 0.6), replace = TRUE)
Boundaries[Boundaries == "Strong:StrongWest:Strong"] = sample(STRENGTH, length(which(Boundaries == "Strong:StrongWest:Strong")), prob = c(0, 0.2, 0.8), replace = TRUE)
Boundaries[Boundaries == "Strong:Westerly:None"] = sample(STRENGTH, length(which(Boundaries == "Strong:Westerly:None")), prob = c(0, 0.7, 0.3), replace = TRUE)
Boundaries[Boundaries == "Strong:Westerly:Weak"] = sample(STRENGTH, length(which(Boundaries == "Strong:Westerly:Weak")), prob = c(0, 0.5, 0.5), replace = TRUE)
Boundaries[Boundaries == "Strong:Westerly:Strong"] = sample(STRENGTH, length(which(Boundaries == "Strong:Westerly:Strong")), prob = c(0, 0.2, 0.8), replace = TRUE)
Boundaries[Boundaries == "Strong:Other:None"] = sample(STRENGTH, length(which(Boundaries == "Strong:Other:None")), prob = c(0.02, 0.73, 0.25), replace = TRUE)
Boundaries[Boundaries == "Strong:Other:Weak"] = sample(STRENGTH, length(which(Boundaries == "Strong:Other:Weak")), prob = c(0.01, 0.5, 0.49), replace = TRUE)
Boundaries[Boundaries == "Strong:Other:Strong"] = sample(STRENGTH, length(which(Boundaries == "Strong:Other:Strong")), prob = c(0.01, 0.2, 0.79), replace = TRUE)


CompPlFcst = apply(cbind(Boundaries, CldShadeConv, AreaMesoALS, CldShadeOth), 1, paste, collapse = ":")
CompPlFcst[CompPlFcst == "None:None:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:None:StrongUp:Cloudy")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:None:StrongUp:PC")), prob = c(0.1, 0.35, 0.55), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:None:StrongUp:Clear")), prob = c(0.05, 0.3, 0.65), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:None:WeakUp:Cloudy")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:None:WeakUp:PC")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:None:WeakUp:Clear")), prob = c(0.2, 0.5, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:None:Neutral:Cloudy")), prob = c(0.6, 0.35, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "None:None:Neutral:PC")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "None:None:Neutral:Clear")), prob = c(0.25, 0.45, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:None:Down:Cloudy")), prob = c(0.7, 0.27, 0.03), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Down:PC"] = sample(FCST, length(which(CompPlFcst == "None:None:Down:PC")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "None:None:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "None:None:Down:Clear")), prob = c(0.6, 0.35, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Some:StrongUp:Cloudy")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:Some:StrongUp:PC")), prob = c(0.25, 0.3, 0.45), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Some:StrongUp:Clear")), prob = c(0.15, 0.35, 0.5), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Some:WeakUp:Cloudy")), prob = c(0.65, 0.25, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:Some:WeakUp:PC")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Some:WeakUp:Clear")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Some:Neutral:Cloudy")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "None:Some:Neutral:PC")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Some:Neutral:Clear")), prob = c(0.3, 0.45, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Some:Down:Cloudy")), prob = c(0.75, 0.23, 0.02), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Down:PC"] = sample(FCST, length(which(CompPlFcst == "None:Some:Down:PC")), prob = c(0.7, 0.26, 0.04), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Some:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Some:Down:Clear")), prob = c(0.65, 0.32, 0.03), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Marked:StrongUp:Cloudy")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:Marked:StrongUp:PC")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Marked:StrongUp:Clear")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Marked:WeakUp:Cloudy")), prob = c(0.7, 0.22, 0.08), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "None:Marked:WeakUp:PC")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Marked:WeakUp:Clear")), prob = c(0.4, 0.45, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Neutral:Cloudy")), prob = c(0.7, 0.27, 0.03), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Neutral:PC")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Neutral:Clear")), prob = c(0.55, 0.33, 0.12), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Down:Cloudy")), prob = c(0.85, 0.14, 0.01), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Down:PC"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Down:PC")), prob = c(0.8, 0.17, 0.03), replace = TRUE)
CompPlFcst[CompPlFcst == "None:Marked:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "None:Marked:Down:Clear")), prob = c(0.75, 0.23, 0.02), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:None:StrongUp:Cloudy")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:None:StrongUp:PC")), prob = c(0.05, 0.35, 0.6), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:None:StrongUp:Clear")), prob = c(0.03, 0.25, 0.72), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:None:WeakUp:Cloudy")), prob = c(0.5, 0.25, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:None:WeakUp:PC")), prob = c(0.3, 0.35, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:None:WeakUp:Clear")), prob = c(0.15, 0.45, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Neutral:Cloudy")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Neutral:PC")), prob = c(0.4, 0.4, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Neutral:Clear")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Down:Cloudy")), prob = c(0.6, 0.35, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Down:PC")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:None:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:None:Down:Clear")), prob = c(0.55, 0.33, 0.12), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:StrongUp:Cloudy")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:StrongUp:PC")), prob = c(0.1, 0.35, 0.55), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:StrongUp:Clear")), prob = c(0.05, 0.3, 0.65), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:WeakUp:Cloudy")), prob = c(0.55, 0.25, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:WeakUp:PC")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:WeakUp:Clear")), prob = c(0.2, 0.5, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Neutral:Cloudy")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Neutral:PC")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Neutral:Clear")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Down:Cloudy")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Down:PC")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Some:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Some:Down:Clear")), prob = c(0.6, 0.35, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:StrongUp:Cloudy")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:StrongUp:PC")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:StrongUp:Clear")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:WeakUp:Cloudy")), prob = c(0.65, 0.25, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:WeakUp:PC")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:WeakUp:Clear")), prob = c(0.3, 0.5, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Neutral:Cloudy")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Neutral:PC")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Neutral:Clear")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Down:Cloudy")), prob = c(0.78, 0.18, 0.04), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Down:PC")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Weak:Marked:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Weak:Marked:Down:Clear")), prob = c(0.7, 0.25, 0.05), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:None:StrongUp:Cloudy")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:None:StrongUp:PC")), prob = c(0.01, 0.25, 0.74), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:None:StrongUp:Clear")), prob = c(0.01, 0.2, 0.79), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:None:WeakUp:Cloudy")), prob = c(0.35, 0.25, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:None:WeakUp:PC")), prob = c(0.15, 0.4, 0.45), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:None:WeakUp:Clear")), prob = c(0.1, 0.35, 0.55), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Neutral:Cloudy")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Neutral:PC")), prob = c(0.3, 0.4, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Neutral:Clear")), prob = c(0.15, 0.4, 0.45), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Down:Cloudy")), prob = c(0.5, 0.35, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Down:PC")), prob = c(0.48, 0.32, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:None:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:None:Down:Clear")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:StrongUp:Cloudy")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:StrongUp:PC")), prob = c(0.05, 0.6, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:StrongUp:Clear")), prob = c(0.04, 0.27, 0.69), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:WeakUp:Cloudy")), prob = c(0.4, 0.25, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:WeakUp:PC")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:WeakUp:Clear")), prob = c(0.12, 0.43, 0.45), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Neutral:Cloudy")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Neutral:PC")), prob = c(0.35, 0.4, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Neutral:Clear")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Down:Cloudy")), prob = c(0.55, 0.35, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Down:PC")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Some:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Some:Down:Clear")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:StrongUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:StrongUp:Cloudy")), prob = c(0.3, 0.35, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:StrongUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:StrongUp:PC")), prob = c(0.15, 0.35, 0.5), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:StrongUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:StrongUp:Clear")), prob = c(0.13, 0.35, 0.52), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:WeakUp:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:WeakUp:Cloudy")), prob = c(0.5, 0.25, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:WeakUp:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:WeakUp:PC")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:WeakUp:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:WeakUp:Clear")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Neutral:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Neutral:Cloudy")), prob = c(0.55, 0.35, 0.1), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Neutral:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Neutral:PC")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Neutral:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Neutral:Clear")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Down:Cloudy"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Down:Cloudy")), prob = c(0.7, 0.24, 0.06), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Down:PC"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Down:PC")), prob = c(0.65, 0.28, 0.07), replace = TRUE)
CompPlFcst[CompPlFcst == "Strong:Marked:Down:Clear"] = sample(FCST, length(which(CompPlFcst == "Strong:Marked:Down:Clear")), prob = c(0.6, 0.3, 0.1), replace = TRUE)

CapChange = CompPlFcst
CapChange[CapChange == "IncCapDecIns"] = sample(DEC, length(which(CapChange == "IncCapDecIns")), prob = c(0, 0, 1), replace = TRUE)
CapChange[CapChange == "LittleChange"] = sample(DEC, length(which(CapChange == "LittleChange")), prob = c(0, 1, 0), replace = TRUE)
CapChange[CapChange == "DecCapIncIns"] = sample(DEC, length(which(CapChange == "DecCapIncIns")), prob = c(1, 0, 0), replace = TRUE)


CapInScen = apply(cbind(AMCINInScen, CapChange), 1, paste, collapse = ":")
CapInScen[CapInScen == "LessThanAve:Decreasing"] = sample(AVE, length(which(CapInScen == "LessThanAve:Decreasing")), prob = c(1, 0, 0), replace = TRUE)
CapInScen[CapInScen == "LessThanAve:LittleChange"] = sample(AVE, length(which(CapInScen == "LessThanAve:LittleChange")), prob = c(0.98, 0.02, 0), replace = TRUE)
CapInScen[CapInScen == "LessThanAve:Increasing"] = sample(AVE, length(which(CapInScen == "LessThanAve:Increasing")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
CapInScen[CapInScen == "Average:Decreasing"] = sample(AVE, length(which(CapInScen == "Average:Decreasing")), prob = c(0.75, 0.25, 0), replace = TRUE)
CapInScen[CapInScen == "Average:LittleChange"] = sample(AVE, length(which(CapInScen == "Average:LittleChange")), prob = c(0.03, 0.94, 0.03), replace = TRUE)
CapInScen[CapInScen == "Average:Increasing"] = sample(AVE, length(which(CapInScen == "Average:Increasing")), prob = c(0, 0.25, 0.75), replace = TRUE)
CapInScen[CapInScen == "MoreThanAve:Decreasing"] = sample(AVE, length(which(CapInScen == "MoreThanAve:Decreasing")), prob = c(0.3, 0.35, 0.35), replace = TRUE)
CapInScen[CapInScen == "MoreThanAve:LittleChange"] = sample(AVE, length(which(CapInScen == "MoreThanAve:LittleChange")), prob = c(0, 0.02, 0.98), replace = TRUE)
CapInScen[CapInScen == "MoreThanAve:Increasing"] = sample(AVE, length(which(CapInScen == "MoreThanAve:Increasing")), prob = c(0, 0, 1), replace = TRUE)

AMInsWliScen = apply(cbind(ScenRelAMIns, LIfr12ZDENSd, AMDewptCalPl), 1, paste, collapse = ":")
AMInsWliScen[AMInsWliScen == "ABI:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "ABI:LIGt0:Instability")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "ABI:LIGt0:Neutral")), prob = c(0.85, 0.13, 0.02), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "ABI:LIGt0:Stability")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "ABI:N1GtLIGt_4:Instability")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "ABI:N1GtLIGt_4:Neutral")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "ABI:N1GtLIGt_4:Stability")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "ABI:N5GtLIGt_8:Instability")), prob = c(0.06, 0.21, 0.73), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "ABI:N5GtLIGt_8:Neutral")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "ABI:N5GtLIGt_8:Stability")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "ABI:LILt_8:Instability")), prob = c(0.01, 0.04, 0.95), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "ABI:LILt_8:Neutral")), prob = c(0.05, 0.2, 0.75), replace = TRUE)
AMInsWliScen[AMInsWliScen == "ABI:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "ABI:LILt_8:Stability")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LIGt0:Instability")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LIGt0:Neutral")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LIGt0:Stability")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N1GtLIGt_4:Instability")), prob = c(0.15, 0.3, 0.55), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N1GtLIGt_4:Neutral")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N1GtLIGt_4:Stability")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N5GtLIGt_8:Instability")), prob = c(0.03, 0.17, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N5GtLIGt_8:Neutral")), prob = c(0.2, 0.3, 0.5), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:N5GtLIGt_8:Stability")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LILt_8:Instability")), prob = c(0.01, 0.04, 0.95), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LILt_8:Neutral")), prob = c(0.05, 0.18, 0.77), replace = TRUE)
AMInsWliScen[AMInsWliScen == "CDEJ:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "CDEJ:LILt_8:Stability")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "F:LIGt0:Instability")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "F:LIGt0:Neutral")), prob = c(0.55, 0.4, 0.05), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "F:LIGt0:Stability")), prob = c(0.85, 0.13, 0.02), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "F:N1GtLIGt_4:Instability")), prob = c(0.07, 0.38, 0.55), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "F:N1GtLIGt_4:Neutral")), prob = c(0.2, 0.6, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "F:N1GtLIGt_4:Stability")), prob = c(0.5, 0.43, 0.07), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "F:N5GtLIGt_8:Instability")), prob = c(0, 0.05, 0.95), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "F:N5GtLIGt_8:Neutral")), prob = c(0.05, 0.35, 0.6), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "F:N5GtLIGt_8:Stability")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "F:LILt_8:Instability")), prob = c(0, 0.02, 0.98), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "F:LILt_8:Neutral")), prob = c(0, 0.05, 0.95), replace = TRUE)
AMInsWliScen[AMInsWliScen == "F:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "F:LILt_8:Stability")), prob = c(0.04, 0.16, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "G:LIGt0:Instability")), prob = c(0.3, 0.4, 0.3), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "G:LIGt0:Neutral")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "G:LIGt0:Stability")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "G:N1GtLIGt_4:Instability")), prob = c(0.15, 0.35, 0.5), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "G:N1GtLIGt_4:Neutral")), prob = c(0.2, 0.6, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "G:N1GtLIGt_4:Stability")), prob = c(0.15, 0.7, 0.15), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "G:N5GtLIGt_8:Instability")), prob = c(0.07, 0.23, 0.7), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "G:N5GtLIGt_8:Neutral")), prob = c(0.13, 0.47, 0.4), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "G:N5GtLIGt_8:Stability")), prob = c(0.1, 0.75, 0.15), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "G:LILt_8:Instability")), prob = c(0.02, 0.18, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "G:LILt_8:Neutral")), prob = c(0.04, 0.26, 0.7), replace = TRUE)
AMInsWliScen[AMInsWliScen == "G:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "G:LILt_8:Stability")), prob = c(0.07, 0.3, 0.63), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "H:LIGt0:Instability")), prob = c(0.35, 0.45, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "H:LIGt0:Neutral")), prob = c(0.4, 0.5, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "H:LIGt0:Stability")), prob = c(0.58, 0.4, 0.02), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "H:N1GtLIGt_4:Instability")), prob = c(0.1, 0.25, 0.65), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "H:N1GtLIGt_4:Neutral")), prob = c(0.15, 0.45, 0.4), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "H:N1GtLIGt_4:Stability")), prob = c(0.4, 0.45, 0.15), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "H:N5GtLIGt_8:Instability")), prob = c(0.02, 0.18, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "H:N5GtLIGt_8:Neutral")), prob = c(0.05, 0.25, 0.7), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "H:N5GtLIGt_8:Stability")), prob = c(0.15, 0.35, 0.5), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "H:LILt_8:Instability")), prob = c(0.01, 0.09, 0.9), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "H:LILt_8:Neutral")), prob = c(0.03, 0.17, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "H:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "H:LILt_8:Stability")), prob = c(0.08, 0.32, 0.6), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LIGt0:Instability"] = sample(UNST, length(which(AMInsWliScen == "K:LIGt0:Instability")), prob = c(0.3, 0.55, 0.15), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LIGt0:Neutral"] = sample(UNST, length(which(AMInsWliScen == "K:LIGt0:Neutral")), prob = c(0.4, 0.5, 0.1), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LIGt0:Stability"] = sample(UNST, length(which(AMInsWliScen == "K:LIGt0:Stability")), prob = c(0.5, 0.43, 0.07), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N1GtLIGt_4:Instability"] = sample(UNST, length(which(AMInsWliScen == "K:N1GtLIGt_4:Instability")), prob = c(0.1, 0.35, 0.55), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N1GtLIGt_4:Neutral"] = sample(UNST, length(which(AMInsWliScen == "K:N1GtLIGt_4:Neutral")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N1GtLIGt_4:Stability"] = sample(UNST, length(which(AMInsWliScen == "K:N1GtLIGt_4:Stability")), prob = c(0.3, 0.5, 0.2), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N5GtLIGt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "K:N5GtLIGt_8:Instability")), prob = c(0.05, 0.22, 0.73), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N5GtLIGt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "K:N5GtLIGt_8:Neutral")), prob = c(0.1, 0.35, 0.55), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:N5GtLIGt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "K:N5GtLIGt_8:Stability")), prob = c(0.15, 0.35, 0.5), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LILt_8:Instability"] = sample(UNST, length(which(AMInsWliScen == "K:LILt_8:Instability")), prob = c(0.02, 0.1, 0.88), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LILt_8:Neutral"] = sample(UNST, length(which(AMInsWliScen == "K:LILt_8:Neutral")), prob = c(0.04, 0.16, 0.8), replace = TRUE)
AMInsWliScen[AMInsWliScen == "K:LILt_8:Stability"] = sample(UNST, length(which(AMInsWliScen == "K:LILt_8:Stability")), prob = c(0.1, 0.25, 0.65), replace = TRUE)

InsChange = apply(cbind(LoLevMoistAd, CompPlFcst), 1, paste, collapse = ":")
InsChange[InsChange == "StrongPos:IncCapDecIns"] = sample(DEC, length(which(InsChange == "StrongPos:IncCapDecIns")), prob = c(0, 0.05, 0.95), replace = TRUE)
InsChange[InsChange == "StrongPos:LittleChange"] = sample(DEC, length(which(InsChange == "StrongPos:LittleChange")), prob = c(0, 0.12, 0.88), replace = TRUE)
InsChange[InsChange == "StrongPos:DecCapIncIns"] = sample(DEC, length(which(InsChange == "StrongPos:DecCapIncIns")), prob = c(0.05, 0.15, 0.8), replace = TRUE)
InsChange[InsChange == "WeakPos:IncCapDecIns"] = sample(DEC, length(which(InsChange == "WeakPos:IncCapDecIns")), prob = c(0.05, 0.15, 0.8), replace = TRUE)
InsChange[InsChange == "WeakPos:LittleChange"] = sample(DEC, length(which(InsChange == "WeakPos:LittleChange")), prob = c(0.1, 0.4, 0.5), replace = TRUE)
InsChange[InsChange == "WeakPos:DecCapIncIns"] = sample(DEC, length(which(InsChange == "WeakPos:DecCapIncIns")), prob = c(0.25, 0.5, 0.25), replace = TRUE)
InsChange[InsChange == "Neutral:IncCapDecIns"] = sample(DEC, length(which(InsChange == "Neutral:IncCapDecIns")), prob = c(0.15, 0.5, 0.35), replace = TRUE)
InsChange[InsChange == "Neutral:LittleChange"] = sample(DEC, length(which(InsChange == "Neutral:LittleChange")), prob = c(0.2, 0.6, 0.2), replace = TRUE)
InsChange[InsChange == "Neutral:DecCapIncIns"] = sample(DEC, length(which(InsChange == "Neutral:DecCapIncIns")), prob = c(0.35, 0.5, 0.15), replace = TRUE)
InsChange[InsChange == "Negative:IncCapDecIns"] = sample(DEC, length(which(InsChange == "Negative:IncCapDecIns")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
InsChange[InsChange == "Negative:LittleChange"] = sample(DEC, length(which(InsChange == "Negative:LittleChange")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
InsChange[InsChange == "Negative:DecCapIncIns"] = sample(DEC, length(which(InsChange == "Negative:DecCapIncIns")), prob = c(0.9, 0.09, 0.01), replace = TRUE)

InsSclInScen = apply(cbind(AMInsWliScen, InsChange), 1, paste, collapse = ":")
InsSclInScen[InsSclInScen == "LessUnstable:Decreasing"] = sample(UNST, length(which(InsSclInScen == "LessUnstable:Decreasing")), prob = c(1, 0, 0), replace = TRUE)
InsSclInScen[InsSclInScen == "LessUnstable:LittleChange"] = sample(UNST, length(which(InsSclInScen == "LessUnstable:LittleChange")), prob = c(0.9, 0.1, 0), replace = TRUE)
InsSclInScen[InsSclInScen == "LessUnstable:Increasing"] = sample(UNST, length(which(InsSclInScen == "LessUnstable:Increasing")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
InsSclInScen[InsSclInScen == "Average:Decreasing"] = sample(UNST, length(which(InsSclInScen == "Average:Decreasing")), prob = c(0.6, 0.4, 0), replace = TRUE)
InsSclInScen[InsSclInScen == "Average:LittleChange"] = sample(UNST, length(which(InsSclInScen == "Average:LittleChange")), prob = c(0.15, 0.7, 0.15), replace = TRUE)
InsSclInScen[InsSclInScen == "Average:Increasing"] = sample(UNST, length(which(InsSclInScen == "Average:Increasing")), prob = c(0, 0.4, 0.6), replace = TRUE)
InsSclInScen[InsSclInScen == "MoreUnstable:Decreasing"] = sample(UNST, length(which(InsSclInScen == "MoreUnstable:Decreasing")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
InsSclInScen[InsSclInScen == "MoreUnstable:LittleChange"] = sample(UNST, length(which(InsSclInScen == "MoreUnstable:LittleChange")), prob = c(0, 0.1, 0.9), replace = TRUE)
InsSclInScen[InsSclInScen == "MoreUnstable:Increasing"] = sample(UNST, length(which(InsSclInScen == "MoreUnstable:Increasing")), prob = c(0, 0, 1), replace = TRUE)

PlainsFcst = apply(cbind(CurPropConv, InsSclInScen, CapInScen, ScnRelPlFcst), 1, paste, collapse = ":")
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:A")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:B")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:C")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:D")), prob = c(0.9, 0.06, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:E")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:F")), prob = c(0.92, 0.08, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:G")), prob = c(0.85, 0.13, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:H")), prob = c(1, 0, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:I")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:J")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:LessThanAve:K")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:A")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:B")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:C")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:D")), prob = c(0.91, 0.05, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:E")), prob = c(0.85, 0.13, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:F")), prob = c(0.9, 0.1, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:G")), prob = c(0.84, 0.12, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:H")), prob = c(0.99, 0.01, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:I")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:J")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:Average:K")), prob = c(0.96, 0.03, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:A")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:B")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:C")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:D")), prob = c(0.93, 0.04, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:E")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:F")), prob = c(0.87, 0.13, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:G")), prob = c(0.9, 0.06, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:H")), prob = c(0.98, 0.02, 0), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:I")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:J")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:LessUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:LessUnstable:MoreThanAve:K")), prob = c(0.97, 0.02, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:A")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:B")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:C")), prob = c(0.8, 0.14, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:D")), prob = c(0.85, 0.09, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:E")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:F")), prob = c(0.88, 0.11, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:G")), prob = c(0.8, 0.17, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:H")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:I")), prob = c(0.8, 0.12, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:J")), prob = c(0.75, 0.22, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:Average:LessThanAve:K")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:A"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:A")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:B"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:B")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:C"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:C")), prob = c(0.82, 0.13, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:D"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:D")), prob = c(0.82, 0.1, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:E"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:E")), prob = c(0.75, 0.18, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:F"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:F")), prob = c(0.88, 0.11, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:G"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:G")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:H"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:H")), prob = c(0.9, 0.07, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:I"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:I")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:J"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:J")), prob = c(0.8, 0.15, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:Average:K"] = sample(FCST2, length(which(PlainsFcst == "None:Average:Average:K")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:A")), prob = c(0.5, 0.2, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:B")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:C")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:D")), prob = c(0.85, 0.07, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:E")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:F")), prob = c(0.85, 0.14, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:G")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:H")), prob = c(0.94, 0.05, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:I")), prob = c(0.65, 0.22, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:J")), prob = c(0.83, 0.1, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "None:Average:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:Average:MoreThanAve:K")), prob = c(0.93, 0.06, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:A")), prob = c(0.35, 0.2, 0.45), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:B")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:C")), prob = c(0.8, 0.1, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:D")), prob = c(0.72, 0.14, 0.14), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:E")), prob = c(0.78, 0.15, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:F")), prob = c(0.86, 0.12, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:G")), prob = c(0.65, 0.25, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:H")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:I")), prob = c(0.65, 0.2, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:J")), prob = c(0.72, 0.2, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:LessThanAve:K")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:A")), prob = c(0.25, 0.15, 0.6), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:B")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:C")), prob = c(0.65, 0.2, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:D")), prob = c(0.55, 0.2, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:E")), prob = c(0.55, 0.25, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:F")), prob = c(0.81, 0.17, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:G")), prob = c(0.6, 0.28, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:H")), prob = c(0.8, 0.13, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:I")), prob = c(0.6, 0.2, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:J")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:Average:K")), prob = c(0.88, 0.08, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:A")), prob = c(0.4, 0.08, 0.52), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:B")), prob = c(0.45, 0.25, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:C")), prob = c(0.75, 0.1, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:D")), prob = c(0.65, 0.15, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:E")), prob = c(0.52, 0.25, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:F")), prob = c(0.82, 0.16, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:G")), prob = c(0.65, 0.27, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:H")), prob = c(0.85, 0.09, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:I")), prob = c(0.5, 0.2, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:J")), prob = c(0.77, 0.1, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "None:MoreUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "None:MoreUnstable:MoreThanAve:K")), prob = c(0.9, 0.07, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:A")), prob = c(0.7, 0.25, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:B")), prob = c(0.6, 0.33, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:C")), prob = c(0.82, 0.13, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:D")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:E")), prob = c(0.82, 0.15, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:F")), prob = c(0.85, 0.14, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:G")), prob = c(0.8, 0.17, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:H")), prob = c(0.97, 0.02, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:I")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:J")), prob = c(0.86, 0.1, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:LessThanAve:K")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:A")), prob = c(0.65, 0.25, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:B")), prob = c(0.58, 0.32, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:C")), prob = c(0.8, 0.15, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:D")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:E")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:F")), prob = c(0.83, 0.16, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:G")), prob = c(0.77, 0.17, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:H")), prob = c(0.93, 0.06, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:I")), prob = c(0.85, 0.12, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:J")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:Average:K")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:A")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:B")), prob = c(0.65, 0.28, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:C")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:D")), prob = c(0.85, 0.1, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:E")), prob = c(0.82, 0.13, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:F")), prob = c(0.8, 0.19, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:G")), prob = c(0.8, 0.13, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:H")), prob = c(0.91, 0.08, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:I")), prob = c(0.85, 0.12, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:J")), prob = c(0.9, 0.08, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:LessUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:LessUnstable:MoreThanAve:K")), prob = c(0.93, 0.06, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:A")), prob = c(0.3, 0.4, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:B")), prob = c(0.55, 0.34, 0.11), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:C")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:D")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:E")), prob = c(0.62, 0.28, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:F")), prob = c(0.85, 0.14, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:G")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:H")), prob = c(0.82, 0.14, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:I")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:J")), prob = c(0.68, 0.22, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:LessThanAve:K")), prob = c(0.82, 0.15, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:A")), prob = c(0.28, 0.37, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:B")), prob = c(0.48, 0.35, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:C")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:D")), prob = c(0.7, 0.17, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:E")), prob = c(0.6, 0.29, 0.11), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:F")), prob = c(0.82, 0.16, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:G")), prob = c(0.63, 0.3, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:H")), prob = c(0.8, 0.15, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:I")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:J")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:Average:K")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:A")), prob = c(0.4, 0.28, 0.32), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:B")), prob = c(0.5, 0.25, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:C")), prob = c(0.72, 0.18, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:D")), prob = c(0.65, 0.2, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:E")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:F")), prob = c(0.78, 0.2, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:G")), prob = c(0.55, 0.35, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:H")), prob = c(0.85, 0.12, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:I")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:J")), prob = c(0.73, 0.15, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:Average:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:Average:MoreThanAve:K")), prob = c(0.85, 0.12, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:A")), prob = c(0.3, 0.25, 0.45), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:B")), prob = c(0.4, 0.36, 0.24), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:C")), prob = c(0.65, 0.2, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:D")), prob = c(0.6, 0.2, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:E")), prob = c(0.6, 0.28, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:F")), prob = c(0.83, 0.14, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:G")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:H")), prob = c(0.7, 0.18, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:I")), prob = c(0.55, 0.25, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:J")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:LessThanAve:K")), prob = c(0.72, 0.2, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:A")), prob = c(0.22, 0.17, 0.61), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:B")), prob = c(0.35, 0.37, 0.28), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:C")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:D")), prob = c(0.45, 0.25, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:E")), prob = c(0.48, 0.29, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:F")), prob = c(0.72, 0.25, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:G")), prob = c(0.43, 0.4, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:H")), prob = c(0.7, 0.18, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:I")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:J")), prob = c(0.6, 0.2, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:Average:K")), prob = c(0.74, 0.16, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:A")), prob = c(0.27, 0.1, 0.63), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:B")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:C")), prob = c(0.55, 0.22, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:D")), prob = c(0.45, 0.25, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:E")), prob = c(0.42, 0.3, 0.28), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:F")), prob = c(0.74, 0.22, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:G")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:H")), prob = c(0.77, 0.13, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:I")), prob = c(0.3, 0.25, 0.45), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:J")), prob = c(0.68, 0.15, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Slight:MoreUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Slight:MoreUnstable:MoreThanAve:K")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:A")), prob = c(0.5, 0.4, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:B")), prob = c(0.45, 0.42, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:C")), prob = c(0.75, 0.18, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:D")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:E")), prob = c(0.72, 0.22, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:F")), prob = c(0.78, 0.21, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:G")), prob = c(0.66, 0.27, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:H")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:I")), prob = c(0.7, 0.22, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:J")), prob = c(0.78, 0.16, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:LessThanAve:K")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:A")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:B")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:C")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:D")), prob = c(0.72, 0.17, 0.11), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:E")), prob = c(0.7, 0.22, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:F")), prob = c(0.75, 0.24, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:G")), prob = c(0.62, 0.3, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:H")), prob = c(0.85, 0.12, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:I")), prob = c(0.75, 0.15, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:J")), prob = c(0.76, 0.17, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:Average:K")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:A")), prob = c(0.35, 0.4, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:B")), prob = c(0.45, 0.4, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:C")), prob = c(0.75, 0.19, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:D")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:E")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:F")), prob = c(0.72, 0.27, 0.01), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:G")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:H")), prob = c(0.8, 0.16, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:I")), prob = c(0.75, 0.17, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:J")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:LessUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:LessUnstable:MoreThanAve:K")), prob = c(0.88, 0.1, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:A")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:B")), prob = c(0.4, 0.4, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:C")), prob = c(0.7, 0.2, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:D")), prob = c(0.65, 0.22, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:E")), prob = c(0.5, 0.34, 0.16), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:F")), prob = c(0.74, 0.24, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:G")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:H")), prob = c(0.67, 0.24, 0.09), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:I")), prob = c(0.35, 0.4, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:J")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:LessThanAve:K")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:A")), prob = c(0.23, 0.4, 0.37), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:B")), prob = c(0.38, 0.35, 0.27), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:C")), prob = c(0.58, 0.25, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:D")), prob = c(0.55, 0.25, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:E")), prob = c(0.53, 0.32, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:F")), prob = c(0.73, 0.25, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:G")), prob = c(0.35, 0.53, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:H")), prob = c(0.65, 0.24, 0.11), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:I")), prob = c(0.3, 0.4, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:J")), prob = c(0.6, 0.24, 0.16), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:Average:K")), prob = c(0.68, 0.24, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:A")), prob = c(0.3, 0.34, 0.36), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:B")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:C")), prob = c(0.55, 0.25, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:D")), prob = c(0.5, 0.27, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:E")), prob = c(0.4, 0.38, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:F")), prob = c(0.7, 0.28, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:G")), prob = c(0.35, 0.5, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:H")), prob = c(0.6, 0.25, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:I")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:J")), prob = c(0.62, 0.22, 0.16), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:Average:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:Average:MoreThanAve:K")), prob = c(0.7, 0.22, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:A")), prob = c(0.25, 0.28, 0.47), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:B")), prob = c(0.3, 0.38, 0.32), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:C")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:D")), prob = c(0.5, 0.25, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:E")), prob = c(0.4, 0.35, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:F")), prob = c(0.72, 0.24, 0.04), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:G")), prob = c(0.25, 0.57, 0.18), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:H")), prob = c(0.57, 0.28, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:I")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:J")), prob = c(0.48, 0.26, 0.26), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:LessThanAve:K")), prob = c(0.6, 0.26, 0.14), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:A")), prob = c(0.19, 0.18, 0.63), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:B")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:C")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:D")), prob = c(0.35, 0.3, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:E")), prob = c(0.35, 0.35, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:F")), prob = c(0.65, 0.3, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:G")), prob = c(0.22, 0.58, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:H")), prob = c(0.45, 0.35, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:I")), prob = c(0.25, 0.34, 0.41), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:J")), prob = c(0.48, 0.26, 0.26), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:Average:K")), prob = c(0.58, 0.25, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:A")), prob = c(0.15, 0.16, 0.69), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:B")), prob = c(0.25, 0.3, 0.45), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:C")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:D")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:E")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:F")), prob = c(0.6, 0.34, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:G")), prob = c(0.18, 0.62, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:H")), prob = c(0.47, 0.3, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:I")), prob = c(0.25, 0.3, 0.45), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:J")), prob = c(0.5, 0.22, 0.28), replace = TRUE)
PlainsFcst[PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Moderate:MoreUnstable:MoreThanAve:K")), prob = c(0.5, 0.27, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:A")), prob = c(0.4, 0.45, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:B")), prob = c(0.35, 0.45, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:C")), prob = c(0.6, 0.27, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:D")), prob = c(0.6, 0.22, 0.18), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:E")), prob = c(0.55, 0.32, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:F")), prob = c(0.69, 0.29, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:G")), prob = c(0.54, 0.36, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:H")), prob = c(0.75, 0.2, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:I")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:J")), prob = c(0.7, 0.22, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:LessThanAve:K")), prob = c(0.7, 0.25, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:A")), prob = c(0.35, 0.4, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:B")), prob = c(0.35, 0.4, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:C")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:D")), prob = c(0.55, 0.27, 0.18), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:E")), prob = c(0.5, 0.35, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:F")), prob = c(0.65, 0.33, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:G")), prob = c(0.38, 0.5, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:H")), prob = c(0.7, 0.24, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:I")), prob = c(0.65, 0.2, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:J")), prob = c(0.67, 0.23, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:Average:K")), prob = c(0.7, 0.25, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:A")), prob = c(0.2, 0.45, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:B")), prob = c(0.3, 0.45, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:C")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:D")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:E")), prob = c(0.45, 0.38, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:F")), prob = c(0.6, 0.38, 0.02), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:G")), prob = c(0.28, 0.57, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:H")), prob = c(0.65, 0.28, 0.07), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:I")), prob = c(0.63, 0.25, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:J")), prob = c(0.62, 0.28, 0.1), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:LessUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:LessUnstable:MoreThanAve:K")), prob = c(0.8, 0.17, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:A")), prob = c(0.16, 0.47, 0.37), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:B")), prob = c(0.3, 0.45, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:C")), prob = c(0.45, 0.32, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:D")), prob = c(0.52, 0.26, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:E")), prob = c(0.35, 0.45, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:F")), prob = c(0.65, 0.32, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:G")), prob = c(0.48, 0.39, 0.13), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:H")), prob = c(0.58, 0.3, 0.12), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:I")), prob = c(0.25, 0.45, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:J")), prob = c(0.5, 0.28, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:LessThanAve:K")), prob = c(0.65, 0.27, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:A")), prob = c(0.18, 0.45, 0.37), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:B")), prob = c(0.3, 0.35, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:C")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:D")), prob = c(0.45, 0.3, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:E")), prob = c(0.35, 0.43, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:F")), prob = c(0.62, 0.35, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:G")), prob = c(0.2, 0.65, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:H")), prob = c(0.52, 0.33, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:I")), prob = c(0.23, 0.42, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:J")), prob = c(0.47, 0.3, 0.23), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:Average:K")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:A")), prob = c(0.23, 0.4, 0.37), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:B")), prob = c(0.25, 0.4, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:C")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:D")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:E")), prob = c(0.3, 0.45, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:F")), prob = c(0.57, 0.4, 0.03), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:G")), prob = c(0.15, 0.65, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:H")), prob = c(0.5, 0.33, 0.17), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:I")), prob = c(0.25, 0.36, 0.39), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:J")), prob = c(0.5, 0.28, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:Average:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:Average:MoreThanAve:K")), prob = c(0.55, 0.3, 0.15), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:A")), prob = c(0.18, 0.3, 0.52), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:B")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:C")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:D")), prob = c(0.4, 0.3, 0.3), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:E")), prob = c(0.25, 0.48, 0.27), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:F")), prob = c(0.63, 0.32, 0.05), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:G")), prob = c(0.15, 0.63, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:H")), prob = c(0.4, 0.38, 0.22), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:I")), prob = c(0.2, 0.37, 0.43), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:J")), prob = c(0.3, 0.35, 0.35), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:LessThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:LessThanAve:K")), prob = c(0.5, 0.32, 0.18), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:A")), prob = c(0.15, 0.2, 0.65), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:B")), prob = c(0.18, 0.4, 0.42), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:C")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:D")), prob = c(0.25, 0.35, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:E")), prob = c(0.25, 0.42, 0.33), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:F")), prob = c(0.58, 0.36, 0.06), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:G")), prob = c(0.13, 0.62, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:H")), prob = c(0.3, 0.45, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:I")), prob = c(0.22, 0.35, 0.43), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:J")), prob = c(0.35, 0.32, 0.33), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:Average:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:Average:K")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:A"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:A")), prob = c(0.1, 0.2, 0.7), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:B"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:B")), prob = c(0.2, 0.3, 0.5), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:C"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:C")), prob = c(0.2, 0.4, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:D"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:D")), prob = c(0.23, 0.3, 0.47), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:E"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:E")), prob = c(0.15, 0.45, 0.4), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:F"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:F")), prob = c(0.5, 0.42, 0.08), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:G"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:G")), prob = c(0.1, 0.65, 0.25), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:H"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:H")), prob = c(0.28, 0.4, 0.32), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:I"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:I")), prob = c(0.2, 0.32, 0.48), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:J"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:J")), prob = c(0.3, 0.28, 0.42), replace = TRUE)
PlainsFcst[PlainsFcst == "Strong:MoreUnstable:MoreThanAve:K"] = sample(FCST2, length(which(PlainsFcst == "Strong:MoreUnstable:MoreThanAve:K")), prob = c(0.38, 0.32, 0.3), replace = TRUE)


N34StarFcst = apply(cbind(ScenRel34, PlainsFcst), 1, paste, collapse = ":")
N34StarFcst[N34StarFcst == "ACEFK:XNIL"] = sample(FCST2, length(which(N34StarFcst == "ACEFK:XNIL")), prob = c(0.94, 0.05, 0.01), replace = TRUE)
N34StarFcst[N34StarFcst == "ACEFK:SIG"] = sample(FCST2, length(which(N34StarFcst == "ACEFK:SIG")), prob = c(0.06, 0.89, 0.05), replace = TRUE)
N34StarFcst[N34StarFcst == "ACEFK:SVR"] = sample(FCST2, length(which(N34StarFcst == "ACEFK:SVR")), prob = c(0.01, 0.05, 0.94), replace = TRUE)
N34StarFcst[N34StarFcst == "B:XNIL"] = sample(FCST2, length(which(N34StarFcst == "B:XNIL")), prob = c(0.98, 0.02, 0), replace = TRUE)
N34StarFcst[N34StarFcst == "B:SIG"] = sample(FCST2, length(which(N34StarFcst == "B:SIG")), prob = c(0.04, 0.94, 0.02), replace = TRUE)
N34StarFcst[N34StarFcst == "B:SVR"] = sample(FCST2, length(which(N34StarFcst == "B:SVR")), prob = c(0, 0.03, 0.97), replace = TRUE)
N34StarFcst[N34StarFcst == "D:XNIL"] = sample(FCST2, length(which(N34StarFcst == "D:XNIL")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
N34StarFcst[N34StarFcst == "D:SIG"] = sample(FCST2, length(which(N34StarFcst == "D:SIG")), prob = c(0.01, 0.89, 0.1), replace = TRUE)
N34StarFcst[N34StarFcst == "D:SVR"] = sample(FCST2, length(which(N34StarFcst == "D:SVR")), prob = c(0, 0.01, 0.99), replace = TRUE)
N34StarFcst[N34StarFcst == "GJ:XNIL"] = sample(FCST2, length(which(N34StarFcst == "GJ:XNIL")), prob = c(0.92, 0.06, 0.02), replace = TRUE)
N34StarFcst[N34StarFcst == "GJ:SIG"] = sample(FCST2, length(which(N34StarFcst == "GJ:SIG")), prob = c(0.03, 0.92, 0.05), replace = TRUE)
N34StarFcst[N34StarFcst == "GJ:SVR"] = sample(FCST2, length(which(N34StarFcst == "GJ:SVR")), prob = c(0.01, 0.04, 0.95), replace = TRUE)
N34StarFcst[N34StarFcst == "HI:XNIL"] = sample(FCST2, length(which(N34StarFcst == "HI:XNIL")), prob = c(0.99, 0.01, 0), replace = TRUE)
N34StarFcst[N34StarFcst == "HI:SIG"] = sample(FCST2, length(which(N34StarFcst == "HI:SIG")), prob = c(0.09, 0.9, 0.01), replace = TRUE)
N34StarFcst[N34StarFcst == "HI:SVR"] = sample(FCST2, length(which(N34StarFcst == "HI:SVR")), prob = c(0.03, 0.12, 0.85), replace = TRUE)

R5Fcst = apply(cbind(MountainFcst, N34StarFcst), 1, paste, collapse = ":")
R5Fcst[R5Fcst == "XNIL:XNIL"] = sample(FCST2, length(which(R5Fcst == "XNIL:XNIL")), prob = c(1, 0, 0), replace = TRUE)
R5Fcst[R5Fcst == "XNIL:SIG"] = sample(FCST2, length(which(R5Fcst == "XNIL:SIG")), prob = c(0, 1, 0), replace = TRUE)
R5Fcst[R5Fcst == "XNIL:SVR"] = sample(FCST2, length(which(R5Fcst == "XNIL:SVR")), prob = c(0, 0, 1), replace = TRUE)
R5Fcst[R5Fcst == "SIG:XNIL"] = sample(FCST2, length(which(R5Fcst == "SIG:XNIL")), prob = c(0, 1, 0), replace = TRUE)
R5Fcst[R5Fcst == "SIG:SIG"] = sample(FCST2, length(which(R5Fcst == "SIG:SIG")), prob = c(0, 1, 0), replace = TRUE)
R5Fcst[R5Fcst == "SIG:SVR"] = sample(FCST2, length(which(R5Fcst == "SIG:SVR")), prob = c(0, 0, 1), replace = TRUE)
R5Fcst[R5Fcst == "SVR:XNIL"] = sample(FCST2, length(which(R5Fcst == "SVR:XNIL")), prob = c(0, 0, 1), replace = TRUE)
R5Fcst[R5Fcst == "SVR:SIG"] = sample(FCST2, length(which(R5Fcst == "SVR:SIG")), prob = c(0, 0, 1), replace = TRUE)
R5Fcst[R5Fcst == "SVR:SVR"] = sample(FCST2, length(which(R5Fcst == "SVR:SVR")), prob = c(0, 0, 1), replace = TRUE)

hailfinder = data.frame(
  N07muVerMo = factor(N07muVerMo, levels = VERT),
  SubjVertMo = factor(SubjVertMo, levels = VERT),
  QGVertMotion = factor(QGVertMotion, levels = VERT),
  CombVerMo = factor(CombVerMo, levels = VERT),
  AreaMesoALS = factor(AreaMesoALS, levels = VERT),
  SatContMoist = factor(SatContMoist, levels = WET),
  RaoContMoist = factor(RaoContMoist, levels = WET),
  CombMoisture = factor(CombMoisture, levels = WET),
  AreaMoDryAir = factor(AreaMoDryAir, levels = WET),
  VISCloudCov = factor(VISCloudCov, levels = CLOUDY),
  IRCloudCover = factor(IRCloudCover, levels = CLOUDY),
  CombClouds = factor(CombClouds, levels = CLOUDY),
  CldShadeOth = factor(CldShadeOth, levels = CLOUDY),
  AMInstabMt = factor(AMInstabMt, levels = STRENGTH),
  InsInMt = factor(InsInMt, levels = STRENGTH),
  WndHodograph = factor(WndHodograph, levels = WND),
  OutflowFrMt = factor(OutflowFrMt, levels = STRENGTH),
  MorningBound = factor(MorningBound, levels = STRENGTH),
  Boundaries = factor(Boundaries, levels = STRENGTH),
  CldShadeConv = factor(CldShadeConv, levels = SHADE),
  CompPlFcst = factor(CompPlFcst, levels = FCST),
  CapChange = factor(CapChange, levels = DEC),
  LoLevMoistAd = factor(LoLevMoistAd, levels = LOLEV),
  InsChange = factor(InsChange, levels = DEC),
  MountainFcst = factor(MountainFcst, levels = FCST2),
  Date = factor(Date, levels = DATE),
  Scenario = factor(Scenario, levels = LETTERS[1:11]),
  ScenRelAMCIN = factor(ScenRelAMCIN, levels = SCRLAM),
  MorningCIN = factor(MorningCIN, levels = INHIBIT),
  AMCINInScen = factor(AMCINInScen, levels = AVE),
  CapInScen = factor(CapInScen, levels = AVE),
  ScenRelAMIns = factor(ScenRelAMIns, levels = SAMI),
  LIfr12ZDENSd = factor(LIfr12ZDENSd, levels = LIFR),
  AMDewptCalPl = factor(AMDewptCalPl, levels = AMDEW),
  AMInsWliScen = factor(AMInsWliScen, levels = UNST),
  InsSclInScen = factor(InsSclInScen, levels = UNST),
  ScenRel34 = factor(ScenRel34, levels = SC34),
  LatestCIN = factor(LatestCIN, levels = INHIBIT),
  LLIW = factor(LLIW, levels = LLEV),
  CurPropConv = factor(CurPropConv, levels = STRENGTH2),
  ScnRelPlFcst = factor(ScnRelPlFcst, levels = LETTERS[1:11]),
  PlainsFcst = factor(PlainsFcst, levels = FCST2),
  N34StarFcst = factor(N34StarFcst, levels = FCST2),
  R5Fcst = factor(R5Fcst, levels = FCST2),
  Dewpoints = factor(Dewpoints, levels = DEWPOINTS),
  LowLLapse = factor(LowLLapse, levels = LL2),
  MeanRH = factor(MeanRH, levels = MOIST),
  MidLLapse = factor(MidLLapse, levels = LL),
  MvmtFeatures = factor(MvmtFeatures, levels = MVMT),
  RHRatio = factor(RHRatio, levels = RHRLV),
  SfcWndShfDis = factor(SfcWndShfDis, levels = WIND),
  SynForcng = factor(SynForcng, levels = SYN),
  TempDis = factor(TempDis, levels = TDISLV),
  WindAloft = factor(WindAloft, levels = WLOFT),
  WindFieldMt = factor(WindFieldMt, levels = WNDMT),
  WindFieldPln = factor(WindFieldPln, levels = PLN)
)
