% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_trace}
\alias{bold_trace}
\title{Get BOLD trace files}
\usage{
bold_trace(taxon = NULL, ids = NULL, bin = NULL, container = NULL,
  institutions = NULL, researchers = NULL, geo = NULL, marker = NULL,
  dest = NULL, ...)
}
\arguments{
\item{taxon}{(character) Returns all records containing matching taxa. Taxa includes the ranks of
phylum, class, order, family, subfamily, genus, and species.}

\item{ids}{(character) Returns all records containing matching IDs. IDs include Sample IDs,
Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) Returns all records contained in matching BINs. A BIN is defined by a
Barcode Index Number URI.}

\item{container}{(character) Returns all records contained in matching projects or datasets.
Containers include project codes and dataset codes}

\item{institutions}{(character) Returns all records stored in matching institutions. Institutions
are the Specimen Storing Site.}

\item{researchers}{(character) Returns all records containing matching researcher names.
Researchers include collectors and specimen identifiers.}

\item{geo}{(character) Returns all records collected in matching geographic sites. Geographic
sites includes countries and province/states.}

\item{marker}{(character) Returns all records containing matching marker codes.}

\item{dest}{(character) A directory to write the files to}

\item{...}{Futher args passed on to download.file. See examples.}
}
\value{
Either a data.frame, parsed xml, a httr response object, or a list with length two
(a data.frame w/o nucleotide data, and a list with nucleotide data)
}
\description{
This function downloads files to your machine - it does not load them into your R session.
}
\examples{
\dontrun{
# The progress dialog is pretty verbose, so quiet=TRUE is a nice touch, but not by default
bold_trace(taxon='Osmia', quiet=TRUE)
# Use a specific destination directory
bold_trace(taxon='Bombus', institutions='York University', dest="~/mytarfiles")
# Another example
bold_trace(ids=c('ACRJP618-11','ACRJP619-11'))
}
}

