% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_identify_parents.R
\name{bold_identify_parents}
\alias{bold_identify_parents}
\title{Add taxonomic parent names to a data.frame}
\usage{
bold_identify_parents(x, wide = FALSE)
}
\arguments{
\item{x}{(data.frame/list) list of data.frames - the output from a call to 
\code{\link{bold_identify}}. or a single data.frame from the output from
same. required.}

\item{wide}{(logical) output in long or wide format. See Details. 
Default: \code{FALSE}}
}
\value{
a list of the same length as the input
}
\description{
Add taxonomic parent names to a data.frame
}
\details{
This function gets unique set of taxonomic names from the input
data.frame, then queries \code{\link{bold_tax_name}} to get the 
taxonomic ID, passing it to \code{\link{bold_tax_id}} to get the parent
names, then attaches those to the input data.
}
\section{wide vs long format}{

When \code{wide = FALSE} you get many rows for each record. Essentially, 
we \code{cbind} the taxonomic classification onto the one row from the 
result of \code{\link{bold_identify}}, giving as many rows as there are
taxa in the taxonomic classification.

When \code{wide = TRUE} you get one row for each record - thus the 
dimenions of the input data stay the same. For this option, we take just
the rows for taxonomic ID and name for each taxon in the taxonomic 
classification, and name the columns by the taxon rank, so you get 
\code{phylum} and \code{phylum_id}, and so on.
}
\examples{
\dontrun{
df <- bold_identify(sequences = sequences$seq2)

# long format
out <- bold_identify_parents(df)
str(out)
head(out$seq1)

# wide format
out <- bold_identify_parents(df, wide = TRUE)
str(out)
head(out$seq1)
}
}

