% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrature_and_differentiation.R
\name{ooura_fourier_integrals}
\alias{ooura_fourier_integrals}
\alias{ooura_fourier_sin}
\alias{ooura_fourier_cos}
\title{Ooura Fourier Integrals}
\usage{
ooura_fourier_sin(
  f,
  omega = 1,
  relative_error_tolerance = sqrt(.Machine$double.eps),
  levels = 8
)

ooura_fourier_cos(
  f,
  omega = 1,
  relative_error_tolerance = sqrt(.Machine$double.eps),
  levels = 8
)
}
\arguments{
\item{f}{A function to integrate. It should accept a single numeric value and
return a single numeric value.}

\item{omega}{The frequency parameter for the sine integral.}

\item{relative_error_tolerance}{The relative error tolerance for the approximation.}

\item{levels}{The number of levels of refinement to apply. Default is 8.}
}
\value{
A single numeric value with the computed Fourier sine or cosine integral, with attribute 'relative_error' indicating the relative error of the approximation.
}
\description{
Computing Fourier sine and cosine integrals using Ooura's method.
}
\examples{
# Fourier sine integral of sin(x) with omega = 1
ooura_fourier_sin(function(x) { 1 / x }, omega = 1)
# Fourier cosine integral of cos(x) with omega = 1
ooura_fourier_cos(function(x) { 1/ (x * x + 1) }, omega = 1)
}
