% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgpls_bootYT.R
\name{nbcomp.bootsgpls.para}
\alias{nbcomp.bootsgpls.para}
\title{Number of components for SGPLS using (Y,T) bootstrap 
(parallel version)}
\usage{
nbcomp.bootsgpls.para(
  x,
  y,
  fold = 10,
  eta,
  R,
  scale.x = TRUE,
  maxnt = 10,
  br = TRUE,
  ftype = "iden",
  ncpus = 1,
  plot.it = TRUE,
  typeBCa = TRUE,
  stabvalue = 1e+06,
  verbose = TRUE
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector or matrix of responses.}

\item{fold}{Number of fold for cross-validation.}

\item{eta}{Thresholding parameter. eta should be between 0 and 1.}

\item{R}{Number of resamplings.}

\item{scale.x}{Scale predictors by dividing each predictor variable by 
its sample standard deviation?}

\item{maxnt}{Maximum number of components allowed in a spls model.}

\item{br}{Apply Firth's bias reduction procedure?}

\item{ftype}{Type of Firth's bias reduction procedure. Alternatives are 
"iden" (the approximated version) or "hat" (the original version). 
Default is "iden".}

\item{ncpus}{Number of cpus for parallel computing.}

\item{plot.it}{Plot the results.}

\item{typeBCa}{Include computation for BCa type interval.}

\item{stabvalue}{A value to hard threshold bootstrap estimates computed from
atypical resamplings.}

\item{verbose}{Additionnal information on the algorithm.}
}
\value{
List of four: error matrix, eta optimal, K optimal and the matrix 
of results.
}
\description{
Number of components for SGPLS using (Y,T) bootstrap 
(parallel version)
}
\examples{
set.seed(4619)
data(prostate, package="spls")
nbcomp.bootsgpls.para((prostate$x)[,1:30], prostate$y, R=250, eta=0.2, maxnt=1, typeBCa = FALSE)
\donttest{
set.seed(4619)
data(prostate, package="spls")
nbcomp.bootsgpls.para(prostate$x, prostate$y, R=250, eta=c(0.2,0.6), typeBCa = FALSE)
}
}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Compututing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
accepted.
}
\author{
Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
