% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spls.R
\name{nbcomp.bootspls}
\alias{nbcomp.bootspls}
\title{Title}
\usage{
nbcomp.bootspls(
  x,
  y,
  fold = 10,
  eta,
  R = 500,
  maxnt = 10,
  kappa = 0.5,
  select = "pls2",
  fit = "simpls",
  scale.x = TRUE,
  scale.y = FALSE,
  plot.it = TRUE,
  typeBCa = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector or matrix of responses.}

\item{fold}{Number of fold for cross-validation}

\item{eta}{Thresholding parameter. eta should be between 0 and 1.}

\item{R}{Number of resamplings.}

\item{maxnt}{Maximum number of components allowed in a spls model.}

\item{kappa}{Parameter to control the effect of the concavity of the 
objective function and the closeness of original and surrogate 
direction vectors. kappa is relevant only when responses are multivariate. 
kappa should be between 0 and 0.5. Default is 0.5.}

\item{select}{PLS algorithm for variable selection. Alternatives are 
"pls2" or "simpls". Default is "pls2".}

\item{fit}{PLS algorithm for model fitting. Alternatives are "kernelpls", 
"widekernelpls", "simpls", or "oscorespls". Default is "simpls".}

\item{scale.x}{Scale predictors by dividing each predictor variable by 
its sample standard deviation?}

\item{scale.y}{Scale responses by dividing each response variable by its 
sample standard deviation?}

\item{plot.it}{Plot the results.}

\item{typeBCa}{Include computation for BCa type interval.}

\item{verbose}{Displays information on the algorithm.}
}
\value{
list of 3: mspemat matrix of results, eta.opt numeric value, K.opt numeric value)
}
\description{
Title
}
\examples{
set.seed(314)
data(pine, package = "plsRglm")
Xpine<-pine[,1:10]
ypine<-log(pine[,11])
nbcomp.bootspls(x=Xpine,y=ypine,eta=.2, maxnt=1)
\donttest{
set.seed(314)
data(pine, package = "plsRglm")
Xpine<-pine[,1:10]
ypine<-log(pine[,11])
nbcomp.bootspls.para(x=Xpine,y=ypine,eta=c(.2,.6))
}
}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Compututing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
accepted.
}
\author{
Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
