% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_unused_attached_pkg_fun_linter.R
\name{box_unused_att_pkg_fun_linter}
\alias{box_unused_att_pkg_fun_linter}
\title{\code{box} library unused attached package function linter}
\usage{
box_unused_att_pkg_fun_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}.
}
\description{
Checks that all attached package functions are used within the source file.
}
\details{
For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
code <- "
box::use(
  stringr[str_pad],
)
"

lintr::lint(text = code, linters = box_unused_att_pkg_fun_linter())

code <- "
box::use(
  stringr[alias_func = str_pad],
)
"

lintr::lint(text = code, linters = box_unused_att_pkg_fun_linter())

# okay
code <- "
box::use(
  stringr[str_pad],
)

str_pad()
"

lintr::lint(text = code, linters = box_unused_att_pkg_fun_linter())

code <- "
box::use(
  stringr[alias_func = str_pad],
)

alias_func()
"

lintr::lint(text = code, linters = box_unused_att_pkg_fun_linter())

}
