% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxly.R
\name{boxly}
\alias{boxly}
\title{Create an interactive box plot}
\usage{
boxly(
  outdata,
  color = NULL,
  hover_summary_var = c("n", "min", "q1", "median", "mean", "q3", "max"),
  hover_outlier_label = c("Participant Id", "Parameter value"),
  x_label = "Visit",
  y_label = "Change",
  heading_select_list = "Lab parameter",
  heading_summary_table = "Number of Participants"
)
}
\arguments{
\item{outdata}{An \code{outdata} object created from \code{prepare_ae_forestly()}.}

\item{color}{Color for box plot.}

\item{hover_summary_var}{A character vector of statistics to be displayed
on hover label of box.}

\item{hover_outlier_label}{A character vector of hover label for outlier.}

\item{x_label}{x-axis label.}

\item{y_label}{y-axis label.}

\item{heading_select_list}{Select list menu label.}

\item{heading_summary_table}{Summary table label.}
}
\value{
Interactive box plot.
}
\description{
Create an interactive box plot
}
\examples{
# Only run this example in interactive R sessions
if (interactive()) {
  library(metalite)

  meta_boxly(
    boxly_adsl,
    boxly_adlb,
    population_term = "apat",
    observation_term = "wk12"
  ) |>
    prepare_boxly() |>
    boxly()
}
}
