% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_data_transformation.R
\name{expand_aggregated_data}
\alias{expand_aggregated_data}
\title{Expand aggregated data
Several datasets for the Bradley-Terry Model aggregate the number of wins for each player in a different column.
The models we provide are intended to be used in a long format. A single result for each contest.
This function expands datasets that have aggregated data into this long format.}
\usage{
expand_aggregated_data(d, player0, player1, wins0, wins1, keep)
}
\arguments{
\item{d}{a data frame}

\item{player0}{string with column name of player0}

\item{player1}{string with column name of player1}

\item{wins0}{string with column name of the number of wins of player 0}

\item{wins1}{string with column name of the number of wins of player 1}

\item{keep}{an array of strings with the name of columns we want to keep in the new data frame (and repeat in every expanded row)}
}
\value{
a data frame with the expanded dataset. It will have the columns player1, player0, y, the keep columns, and a rowid column (to make each row unique)
}
\description{
Expand aggregated data
Several datasets for the Bradley-Terry Model aggregate the number of wins for each player in a different column.
The models we provide are intended to be used in a long format. A single result for each contest.
This function expands datasets that have aggregated data into this long format.
}
\examples{
#Creating a simple data frame with only one row to illustrate how the function works
df1 <- tibble::tribble(~player0, ~player1, ~wins0, ~wins1,~cluster, 'A','B',4, 3, 'c1')
df2 <- expand_aggregated_data(df1,'player0', 'player1', 'wins0', 'wins1', keep=c('cluster'))
print(df2)
}
