% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_init.R
\name{brainGraph_init}
\alias{brainGraph_init}
\title{Initialize variables for further use in brainGraph}
\usage{
brainGraph_init(atlas = c("aal116", "aal90", "brainsuite", "destrieux", "dk",
  "dk.scgm", "dkt", "dkt.scgm", "hoa112", "lpba40"), densities, datadir,
  modality = c("thickness", "volume", "lgi", "area"), use.mean = FALSE,
  exclude.subs = NULL)
}
\arguments{
\item{atlas}{A character string indicating which brain atlas you are using}

\item{densities}{A numeric vector of the graph densities you would like to
investigate}

\item{datadir}{A character string; the filesystem location of your input
files}

\item{modality}{A character string indicating the volumetric MRI
modality/measure you are using to create the graphs ('thickness', 'volume',
'lgi', or 'area')}

\item{use.mean}{A logical indicating whether or not you would like to
calculate the mean hemispheric volumetric measure (for later use in linear
models) (default: FALSE)}

\item{exclude.subs}{(optional) A character vector of the Study ID's of
subjects who are to be excluded from the analysis}
}
\value{
A list containing:
\item{atlas}{A character string of the brain atlas name}
\item{densities}{A numeric vector of the graph densities}
\item{modality}{A character string of the modality you chose}
\item{kNumDensities}{An integer indicating the number of densities}
\item{covars}{A \code{data.table} of covariates}
\item{groups}{A character vector of subject group names}
\item{kNumGroups}{An integer indicating the number of groups}
\item{kNumVertices}{An integer; the number of vertices in the graphs}
\item{lhrh}{A \code{data.table} of left- and right-hemispheric volumetric
data}
\item{all.dat}{A merged \code{data.table} of \code{covars} and \code{lhrh}}
\item{all.dat.tidy}{A 'tidied' version of \code{all.dat}}
}
\description{
This function initializes some variables that are important for further
analysis with the \code{brainGraph} package. This mostly involves loading CSV
files (of covariates/demographics, cortical thickness/volumes, etc.) and
returning them as data tables.
}
\details{
The file containing covariates should be names \code{covars.csv}. The files
containing volumetric data should include hemisphere, atlas, and modality,
e.g. \code{lh_dkt_thickness.csv}. If you would like to include subcortical
gray matter, then you will need files \code{covars.scgm.csv} and
\code{scgm.csv}.
}
\examples{
\dontrun{
init.vars <- brainGraph_init(atlas='dkt', densities=seq(0.07, 0.50, 0.01),
datadir='/home/cwatson/Data', modality='thickness', exclude.subs=c('Con07',
'Con23', 'Pat15'), use.mean=FALSE)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

