% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot_brainGraph}
\alias{plot_brainGraph}
\title{Plot a graph with a specific spatial layout}
\usage{
plot_brainGraph(g, rescale = F, ylim = c(-1.5, 1.5), asp = 0,
  main = NULL, ...)
}
\arguments{
\item{g}{The graph to plot}

\item{rescale}{A logical, whether to rescale the coordinates}

\item{ylim}{A vector giving limits for the vertical axis}

\item{asp}{A numeric constant for the aspect ratio}

\item{main}{Character string for the main title}

\item{...}{Other parameters (passed to \code{\link{plot}}).}
}
\description{
This function plots a graph when the spatial layout of the nodes is important
(e.g. in the brain). It is really just a wrapper for
\code{\link{plot.igraph}}, with some options pre-specified that work for
plotting in the brain's layout. This means that
\code{\link{set.brainGraph.attributes}} needs to be run on the graph,
and a valid set of coordinates provided for the vertices. Most of the
parameters valid here can be seen in \code{\link{igraph.plotting}}.
}

