% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_GLM.R
\name{plot.bg_GLM}
\alias{plot.bg_GLM}
\title{Plot GLM diagnostics for a brain network}
\usage{
\method{plot}{bg_GLM}(x, region = NULL, which = c(1L:3L, 5L), ...)
}
\arguments{
\item{x}{A \code{bg_GLM} object}

\item{region}{Character string specifying which region's results to
plot; only relevant if \code{level='vertex'} (default: \code{NULL})}

\item{which}{Integer vector indicating which of the 6 plots to print to the
plot device (default: \code{c(1:3, 5)})}

\item{...}{Unused}
}
\value{
A list of \code{\link[ggplot2]{ggplot}} objects
}
\description{
Plots the GLM diagnostics (similar to that of
\code{\link[stats]{plot.lm}}) for the output of \code{\link{brainGraph_GLM}}.
There are a total of 6 possible plots, specified by the \code{which}
argument; the behavior is the same as in \code{\link[stats]{plot.lm}}. Please
see the help for that function.
}
\examples{
\dontrun{
## Save objects and then to multipage PDF
lmPlots <- plot(x)
ggsave('lmPlots.pdf', lmPlots)

## Save all the GLM sub-objects from MTPC analysis
res.mtpc <- mtpc(...)
glmPlots <- lapply(res.mtpc$res.glm, plot, which=1:6)
ml <- marrangeGrob(glmPlots, nrow=1, ncol=1)
ggsave('glmPlots.pdf', ml, width=8.5, height=11)
}
}
\seealso{
\code{\link[stats]{plot.lm}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
