% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_global.R
\name{plot.brainGraph_boot}
\alias{plot.brainGraph_boot}
\title{Plot bootstrap output of global graph measures across densities}
\usage{
\method{plot}{brainGraph_boot}(x, ..., alpha = 0.4)
}
\arguments{
\item{x}{The object output from \code{\link{brainGraph_boot}}}

\item{...}{Not used}

\item{alpha}{A numeric indicating the opacity for
\code{\link[ggplot2]{geom_ribbon}}}
}
\value{
A \emph{list} with the following elements:
  \item{se}{A ggplot object with ribbon representing standard error}
  \item{ci}{A ggplot object with ribbon representing confidence intervals}
}
\description{
This function plots the output of \code{\link{brainGraph_boot}}, returning two
\code{ggplot} objects: one with shaded regions based on the standard error,
and the other based on confidence intervals (calculated using the normal
approximation.
}
\seealso{
\code{\link{brainGraph_boot}, \link[boot]{boot.ci}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
