% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mats.R
\name{apply_thresholds}
\alias{apply_thresholds}
\title{Threshold additional set of matrices}
\usage{
apply_thresholds(sub.mats, group.mats, W.files, inds)
}
\arguments{
\item{sub.mats}{List (length equal to number of thresholds) of numeric arrays
(3-dim) for all subjects}

\item{group.mats}{List (equal to number of thresholds) of lists (equal to
number of groups) of numeric matrices for group-level data}

\item{W.files}{Character vector of the filenames of the files with
connectivity matrices}

\item{inds}{List (length equal to number of groups) of integers; each list
element should be a vector of length equal to the group sizes}
}
\value{
List containing:
\item{W}{A 3-d array of the raw connection matrices}
\item{W.norm.sub}{List of 3-d arrays of the normalized connection matrices
  for all given thresholds}
\item{W.norm.mean}{List of lists of numeric matrices averaged for each group}
}
\description{
\code{apply_thresholds} thresholds an additional set of matrices (e.g.,
FA-weighted matrices for DTI tractography) based on the matrices that have
been returned from \code{\link{create_mats}}. This ensures that the same
connections are present in both sets of matrices.
}
\details{
The argument \code{W.files} accepts the same formats as \code{A.files}; see
\code{\link{create_mats}} for details.
}
\examples{
\dontrun{
  W.mats <- apply_thresholds(A.norm.sub, A.norm.mean, f.W, inds)
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
