% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bricks-from-tables.R
\name{bricks_from_table}
\alias{bricks_from_table}
\title{Convert a table into a 'brickr' 3D object}
\usage{
bricks_from_table(
  matrix_table,
  color_guide = brickr::lego_colors,
  piece_matrix = NULL,
  use_bricks = NULL,
  .re_level = TRUE,
  increment_level = 0,
  min_level = 1,
  max_level = Inf,
  increment_x = 0,
  max_x = Inf,
  increment_y = 0,
  max_y = Inf,
  exclude_color = NULL,
  exclude_level = NULL
)
}
\arguments{
\item{matrix_table}{A data frame of a 3D brick model design. Left-most column is level/height/z dimension, with rows as Y axis and columns as X axis. See example. Use \code{\link[tibble]{tribble}} for ease.}

\item{color_guide}{A data frame linking numeric \code{.value} in \code{matrix_table} to official LEGO color names. Defaults to data frame 'lego_colors'.}

\item{piece_matrix}{A data frame in same shape as \code{matrix_table} with piece shape IDs.}

\item{use_bricks}{Array of brick sizes to use in mosaic. Defaults to \code{c('4x2', '2x2', '3x1', '2x1', '1x1')}`. '1x1' will always be considered.}

\item{.re_level}{Logical to reassign the Level/z dimension to layers in alphanumeric order. Set to FALSE to explicitly provide levels.}

\item{increment_level}{Default '0'. Use in animations. Shift  Level/z dimension by an integer.}

\item{min_level}{Default '1'. Use in animations. Any Level/z values below this value will be cut off.}

\item{max_level}{Default 'Inf'. Use in animations. Any Level/z values above this value will be cut off.}

\item{increment_x}{Default '0'. Use in animations. Shift x dimension by an integer.}

\item{max_x}{Default 'Inf'. Use in animations. Any x values above this value will be cut off.}

\item{increment_y}{Default '0'. Use in animations. Shift y dimension by an integer.}

\item{max_y}{Default 'Inf'. Use in animations. Any y values above this value will be cut off.}

\item{exclude_color}{Numeric array of color ID numbers to exclude.}

\item{exclude_level}{Numeric array of Level/z dimensions to exclude.}
}
\value{
A list with elements \code{Img_lego} to pass to \code{\link{build_bricks}}.
}
\description{
Create a 3D brick object from a data frame. Left-most column is level/height/z dimension, with rows as Y axis and columns as X axis.
}
\examples{
#This is a 4x2 brick. One level high, 2 x-values (columns), 4 y-values (rows).
brick <- data.frame(
 Level="A",
 X1 = rep(3,4), #The number 3 is the brickrID for 'bright red'
 X2 = rep(3,4)
)

brick \%>\% 
 bricks_from_table() \%>\% 
 build_bricks()
 
 rgl::clear3d()
 
#Build on top of each other by changing the Level value.
#This example builds a blue 2x2 brick on top of a red 2x2
brick <- data.frame(
 Level=c("A", "A", "B", "B"),
 X1 = c(3, 3, 4, 4), #3 is red, 4 is blue
 X2 = c(3, 3, 4, 4)
)

brick \%>\% 
 bricks_from_table() \%>\% 
 build_bricks()
 
 rgl::clear3d()

#Provide an additional piece_matrix  argument to change the default brick shape.
pieces <- data.frame(
 Level=c("A", "A", "B", "B"),
 X1 = c("b", "b", "p", "p"), #b is brick (default), p is plate
 X2 = c("b", "b", "p", "p")
)

\donttest{
brick \%>\% 
 bricks_from_table(piece_matrix=pieces) \%>\% 
 build_bricks()
 
 rgl::clear3d()
 }
 
#Provide a custom table of colors 
custom_colors <- data.frame(
.value = c(3, 4),
Color = c("Bright orange", "Dark green")
)

\donttest{
brick \%>\% 
 bricks_from_table(color_guide  = custom_colors) \%>\% 
 build_bricks()
 
 rgl::clear3d()
 }
 
#Limit the size of bricks used in the model with use_bricks
\donttest{
brick \%>\% 
 bricks_from_table(use_bricks = "2x1") \%>\% #Only use 2x1 bricks.
 build_bricks()
 
 rgl::clear3d()
 }
}
\seealso{
Other 3D Models: 
\code{\link{bricks_from_coords}()},
\code{\link{bricks_from_excel}()},
\code{\link{bricks_from_mosaic}()},
\code{\link{build_bricks}()}
}
\concept{3D Models}
