% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-mosaic.R
\name{build_mosaic}
\alias{build_mosaic}
\title{Display 2D LEGO mosaic as a plot image}
\usage{
build_mosaic(brick_obj, title = NULL)
}
\arguments{
\item{brick_obj}{List output from image_to_bricks(). Contains an element \code{Img_lego}.}

\item{title}{Optional title to include above plotted mosaic.}
}
\value{
A single plot object to display 2D mosaic.
}
\description{
Render a plot image of the 2D brick mosaic with optional title.
}
\examples{

# Import a jpeg or png
 demo_file <- system.file("extdata", "demo_img.jpg", 
                          package = "brickr", mustWork = TRUE)
 demo_image <- jpeg::readJPEG(demo_file)
 
#Build a very small 12x12 mosaic.
 \donttest{
demo_image \%>\% 
 image_to_mosaic(12) \%>\% 
 build_mosaic()
 }

#Build a mosaic in the default size of 48x48 studs with title
\donttest{
demo_image \%>\% 
 image_to_mosaic() \%>\% 
 build_mosaic("Demo mosaic")
 }
}
\seealso{
Other Mosaics: 
\code{\link{image_to_mosaic}()}
}
\concept{Mosaics}
