% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-to-prep-mosaic.R
\name{image_to_scaled}
\alias{image_to_scaled}
\title{Scale an image raster array to a small number of pixels}
\arguments{
\item{image}{A raster array from an image.}

\item{img_size}{Size of output image in pixel, where one pixel = one 'brick'. Use a single value (e.g. \code{48}) for a square image with 48 pixels on each side.
Use an array of two values for a rectangular image \code{c(width, height)}.}

\item{brightness}{A value >1 will increase the brightness of the image while a positive value <1 will decrease the brightness.}

\item{warhol}{Array of values \code{c(1, 2, 3)} associated with R, G, B color channels. Swap values in array to swap color channels for a fun visual effect.}
}
\value{
A list with element \code{Img_scaled} containing a data frame of the x- & y-coordinates, R, G, B channels, and hex color of each brick (pixel).
}
\description{
Decrease the size of an image, in pixel. Process into a data frame. Internal function.
}
\keyword{internal}
