% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_reset}
\alias{db_jobs_reset}
\title{Overwrite All Settings For A Job}
\usage{
db_jobs_reset(
  job_id,
  name,
  schedule,
  tasks,
  job_clusters = NULL,
  email_notifications = NULL,
  timeout_seconds = NULL,
  max_concurrent_runs = 1,
  access_control_list = NULL,
  git_source = NULL,
  queue = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{job_id}{The canonical identifier of the job.}

\item{name}{Name for the job.}

\item{schedule}{Instance of \code{\link[=cron_schedule]{cron_schedule()}}.}

\item{tasks}{Task specifications to be executed by this job. Use
\code{\link[=job_tasks]{job_tasks()}}.}

\item{job_clusters}{Named list of job cluster specifications (using
\code{\link[=new_cluster]{new_cluster()}}) that can be shared and reused by tasks of this job.
Libraries cannot be declared in a shared job cluster. You must declare
dependent libraries in task settings.}

\item{email_notifications}{Instance of \code{\link[=email_notifications]{email_notifications()}}.}

\item{timeout_seconds}{An optional timeout applied to each run of this job.
The default behavior is to have no timeout.}

\item{max_concurrent_runs}{Maximum allowed number of concurrent runs of the
job. Set this value if you want to be able to execute multiple runs of the
same job concurrently. This setting affects only new runs. This value cannot
exceed 1000. Setting this value to 0 causes all new runs to be skipped.
The default behavior is to allow only 1 concurrent run.}

\item{access_control_list}{Instance of \code{\link[=access_control_request]{access_control_request()}}.}

\item{git_source}{Optional specification for a remote repository containing
the notebooks used by this job's notebook tasks. Instance of \code{\link[=git_source]{git_source()}}.}

\item{queue}{If true, enable queueing for the job.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Overwrite All Settings For A Job
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
