% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate_categorical.R
\name{brm_simulate_categorical}
\alias{brm_simulate_categorical}
\title{Append simulated categorical covariates}
\usage{
brm_simulate_categorical(data, names, levels, probabilities = NULL)
}
\arguments{
\item{data}{Classed \code{tibble} as from \code{\link[=brm_data]{brm_data()}}
or \code{\link[=brm_simulate_outline]{brm_simulate_outline()}}.}

\item{names}{Character vector with the names of the new covariates
to simulate and append. Names must all be unique and
must not already be column names of \code{data}.}

\item{levels}{Character vector of unique levels of the
simulated categorical covariates.}

\item{probabilities}{Either \code{NULL} or a
numeric vector of length \code{length(levels)} with levels between 0 and 1
where all elements sum to 1.
If \code{NULL}, then all levels are equally likely to be drawn. If not \code{NULL},
then \code{probabilities} is a vector of sampling probabilities corresponding
to each respective level of \code{levels}.}
}
\value{
A classed \code{tibble}, like from \code{\link[=brm_data]{brm_data()}} or
\code{\link[=brm_simulate_outline]{brm_simulate_outline()}}, but with new categorical covariate columns
and with the names of the new covariates appended to the
\code{brm_covariates} attribute. Each new categorical covariate column
is a character vector, not the factor type in base R.
}
\description{
Simulate and append non-time-varying
categorical covariates to an existing \code{\link[=brm_data]{brm_data()}} dataset.
}
\details{
Each covariate is a new column of the dataset with one independent
random categorical draw for each patient, using a fixed set of levels
(via \code{base::sample()} with \code{replace = TRUE}).
All covariates simulated this way are
independent of everything else in the data, including other covariates
(to the extent that the random number generators in R work as intended).
}
\examples{
data <- brm_simulate_outline()
brm_simulate_categorical(
  data = data,
  names = c("site", "region"),
  levels = c("area1", "area2")
)
brm_simulate_categorical(
  data = data,
  names = c("site", "region"),
  levels = c("area1", "area2"),
  probabilities = c(0.1, 0.9)
)
}
\seealso{
Other simulation: 
\code{\link{brm_simulate_continuous}()},
\code{\link{brm_simulate_outline}()},
\code{\link{brm_simulate_prior}()},
\code{\link{brm_simulate_simple}()}
}
\concept{simulation}
