% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/support.export.R
\name{brm.data}
\alias{brm.data}
\title{Extract required data for \code{brms} models}
\usage{
brm.data(formula, data = NULL, family = c("gaussian", "identity"),
  prior = list(), partial = NULL, engine = "stan", ...)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
The details of model specification are given under 'Details'.}

\item{data}{An optional data frame, list or environment  (or object coercible by \code{as.data.frame} to a data frame) containing
the variables in the model. If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{brm} is called.}

\item{family}{A vector of one or two character strings. The first string indicates the distribution of the dependent variable (the 'family'). Currently, the following families are supported:
\code{"gaussian"}, \code{"student"}, \code{"cauchy"}, \code{"poisson"}, \code{"binomial"}, \code{"categorical"}, \code{"gamma"}, \code{"exponential"},
\code{"weibull"}, \code{"cumulative"}, \code{"cratio"}, \code{"sratio"}, and \code{"acat"}.
The second string indicates the link function, which must be supported by the distribution of the dependent variable.
If not specified, default link functions are used. Further information is provided under 'Details'.}

\item{prior}{A named list of character strings specifing the prior distributions of the parameters. Further information
is provided under 'Details'.}

\item{partial}{A one sided formula of the form \code{~ partial.effects} specifing the predictors that can vary between categories in non-cumulative ordinal models
(i.e. in families \code{"cratio"}, \code{"sratio"}, or \code{"acat"}).}

\item{engine}{A character string, either \code{"stan"} (the default) or \code{"jags"}. Specifies which program should be used to fit the model.
Note that \code{jags} is currently implemented for testing purposes only, does not allow full functionality and is not supported or documented.}

\item{...}{Further arguments for testing purposes only}
}
\value{
A named list of objects containing the required data to fit a \code{brms} model
}
\description{
Extract required data for \code{brms} models
}
\examples{
data1 <- brm.data(rating ~ treat + period + carry + (1|subject),
         data = inhaler, family = "cumulative")
names(data1)

data2 <- brm.data(count ~ log_Age_c + log_Base4_c * Trt_c + (1|patient) + (1|visit),
         data = epilepsy, family = c("poisson", "log"))
names(data2)
}

