% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_trajectory}
\alias{plot_trajectory}
\title{Plot observed and fitted trajectories from fitted brokenstick model}
\usage{
plot_trajectory(
  x,
  newdata = NULL,
  hide = c("right", "left", "boundary", "internal", "none"),
  .x = NULL,
  group = NULL,
  color_y = c(grDevices::hcl(240, 100, 40, 0.7), grDevices::hcl(240, 100, 40, 0.8)),
  size_y = 2,
  linetype_y = 1,
  shape_y = 19,
  color_yhat = c(grDevices::hcl(0, 100, 40, 0.7), grDevices::hcl(0, 100, 40, 0.8)),
  size_yhat = 2,
  linetype_yhat = 1,
  shape_yhat = 19,
  color_imp = c("grey80", "grey80"),
  size_imp = 2,
  ncol = 3L,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  show = c(TRUE, TRUE, FALSE),
  n_plot = 3L,
  scales = "fixed",
  theme = ggplot2::theme_light(),
  whatknots = "droplast",
  ...
)
}
\arguments{
\item{x}{An object of class \code{brokenstick}.}

\item{newdata}{A \code{data.frame} or \code{matrix}}

\item{hide}{Character indicating which knots should}

\item{.x}{The \code{x} argument of the \code{\link[=predict.brokenstick]{predict.brokenstick()}} function.}

\item{group}{A vector with group identifications}

\item{color_y}{A character vector with two elements specifying the symbol and line color of the measured data points}

\item{size_y}{Dot size of measured data points}

\item{linetype_y}{Line type of data points}

\item{shape_y}{Symbol for data points}

\item{color_yhat}{A character vector with two elements specifying the symbol and line color of the predicted data points}

\item{size_yhat}{Dot size of predicted data points}

\item{linetype_yhat}{Line type of predicted data}

\item{shape_yhat}{Symbol for predicted data}

\item{color_imp}{A character vector with two elements specifying the symbol and line color of the imputed data}

\item{size_imp}{Dot size of imputed data}

\item{ncol}{Number of columns in plot}

\item{xlab}{The label of the x-axis}

\item{ylab}{The label of the y-axis}

\item{xlim}{Vector of length 2 with range of x-axis}

\item{ylim}{Vector of length 2 with range of y-axis}

\item{show}{A logical vector of length 3. Element 1 specifies
whether the observed data are plotted, element 2 specifies
whether the broken stick are plotted, element 3 specifies
whether imputations are plotted. The default is
\code{c(TRUE, TRUE, FALSE)}.}

\item{n_plot}{A integer indicating the number of individual plots.
The default is 3, which plots the trajectories of the first three
groups. The \code{n_plot} is a safety measure to prevent unintended
plots of the entire data set.}

\item{scales}{Axis scaling, e.g. \code{"fixed"}, \code{"free"}, and so on}

\item{theme}{Plotting theme}

\item{whatknots}{Deprecated.}

\item{\dots}{Extra arguments passed down to \code{\link[=predict.brokenstick]{predict.brokenstick()}}.}
}
\value{
An object of class \code{ggplot}
}
\description{
Plot observed and fitted trajectories from fitted brokenstick model
}
\seealso{
\link{plot.brokenstick}
}
