% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_model_matrix.R
\name{model_get_model_matrix}
\alias{model_get_model_matrix}
\alias{model_get_model_matrix.default}
\alias{model_get_model_matrix.multinom}
\alias{model_get_model_matrix.clm}
\alias{model_get_model_matrix.brmsfit}
\alias{model_get_model_matrix.glmmTMB}
\alias{model_get_model_matrix.plm}
\alias{model_get_model_matrix.biglm}
\alias{model_get_model_matrix.model_fit}
\alias{model_get_model_matrix.fixest}
\alias{model_get_model_matrix.LORgee}
\title{Get the model matrix of a model}
\usage{
model_get_model_matrix(model, ...)

\method{model_get_model_matrix}{default}(model, ...)

\method{model_get_model_matrix}{multinom}(model, ...)

\method{model_get_model_matrix}{clm}(model, ...)

\method{model_get_model_matrix}{brmsfit}(model, ...)

\method{model_get_model_matrix}{glmmTMB}(model, ...)

\method{model_get_model_matrix}{plm}(model, ...)

\method{model_get_model_matrix}{biglm}(model, ...)

\method{model_get_model_matrix}{model_fit}(model, ...)

\method{model_get_model_matrix}{fixest}(model, ...)

\method{model_get_model_matrix}{LORgee}(model, ...)
}
\arguments{
\item{model}{a model object}

\item{...}{additional arguments passed to \code{\link[stats:model.matrix]{stats::model.matrix()}}}
}
\description{
The structure of the object returned by \code{\link[stats:model.matrix]{stats::model.matrix()}}
could slightly differ for certain types of models.
\code{model_get_model_matrix()} will always return an object
with the same structure as \code{\link[stats:model.matrix]{stats::model.matrix.default()}}.
}
\details{
For models fitted with \code{glmmTMB::glmmTMB()}, it will return a model matrix
taking into account all components ("cond", "zi" and "disp"). For a more
restricted model matrix, please refer to \code{glmmTMB::model.matrix.glmmTMB()}.

For \code{\link[plm:plm]{plm::plm()}} models, constant columns are not removed.
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) \%>\%
  model_get_model_matrix() \%>\%
  head()
}
\seealso{
\code{\link[stats:model.matrix]{stats::model.matrix()}}

Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
