% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_coefficients_type.R
\name{tidy_add_coefficients_type}
\alias{tidy_add_coefficients_type}
\title{Add coefficients type and label as attributes}
\usage{
tidy_add_coefficients_type(
  x,
  exponentiate = attr(x, "exponentiate"),
  model = tidy_get_model(x)
)
}
\arguments{
\item{x}{a tidy tibble}

\item{exponentiate}{logical indicating whether or not to exponentiate the
coefficient estimates. It should be consistent with the original call to
\code{\link[broom:reexports]{broom::tidy()}}}

\item{model}{the corresponding model, if not attached to \code{x}}
}
\description{
Add the type of coefficients ("generic", "logistic", "poisson",
"relative_risk" or "prop_hazard") and the corresponding coefficient labels,
as attributes to \code{x} (respectively
named \code{coefficients_type} and \code{coefficients_label}).
}
\examples{
ex1 <- lm(hp ~ mpg + factor(cyl), mtcars) \%>\%
  tidy_and_attach() \%>\%
  tidy_add_coefficients_type()
attr(ex1, "coefficients_type")
attr(ex1, "coefficients_label")

ex2 <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes"))) \%>\%
  glm(Survived ~ Class + Age * Sex, data = ., weights = .$n, family = binomial) \%>\%
  tidy_and_attach(exponentiate = TRUE) \%>\%
  tidy_add_coefficients_type()
attr(ex2, "coefficients_type")
attr(ex2, "coefficients_label")
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
