% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survfit-tidiers.R
\name{glance.survfit}
\alias{glance.survfit}
\title{Glance at a(n) survfit object}
\usage{
\method{glance}{survfit}(x, ...)
}
\arguments{
\item{x}{An \code{survfit} object returned from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{records}{number of observations}
\item{n.max}{n.max}
\item{n.start}{n.start}
\item{events}{number of events}
\item{rmean}{Restricted mean (see \code{\link[survival:print.survfit]{survival::print.survfit()}}}
\item{rmean.std.error}{Restricted mean standard error}
\item{median}{median survival}
\item{conf.low}{lower end of confidence interval on median}
\item{conf.high}{upper end of confidence interval on median}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[survival:survfit]{survival::survfit()}}

Other cch tidiers: \code{\link{glance.cch}},
  \code{\link{tidy.cch}}

Other survival tidiers: \code{\link{augment.coxph}},
  \code{\link{augment.survreg}},
  \code{\link{glance.aareg}}, \code{\link{glance.cch}},
  \code{\link{glance.coxph}}, \code{\link{glance.pyears}},
  \code{\link{glance.survdiff}},
  \code{\link{glance.survexp}},
  \code{\link{glance.survreg}}, \code{\link{tidy.aareg}},
  \code{\link{tidy.cch}}, \code{\link{tidy.coxph}},
  \code{\link{tidy.pyears}}, \code{\link{tidy.survdiff}},
  \code{\link{tidy.survexp}}, \code{\link{tidy.survfit}},
  \code{\link{tidy.survreg}}
}
\concept{cch tidiers}
\concept{survival tidiers}
