% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmodel2.R
\name{tidy.lmodel2}
\alias{tidy.lmodel2}
\alias{lmodel2_tidiers}
\title{Tidy a(n) lmodel2 object}
\usage{
\method{tidy}{lmodel2}(x, ...)
}
\arguments{
\item{x}{A \code{lmodel2} object returned by \code{\link[lmodel2:lmodel2]{lmodel2::lmodel2()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
There are always only two terms in an \code{lmodel2}: \code{"Intercept"}
and \code{"Slope"}. These are computed by four methods: OLS
(ordinary least squares), MA (major axis), SMA (standard major
axis), and RMA (ranged major axis).

The returned p-value is one-tailed and calculated via a permutation test.
A permutational test is used because distributional assumptions may not
be valid. More information can be found in
\code{vignette("mod2user", package = "lmodel2")}.
}
\examples{
\dontshow{if (rlang::is_installed(c("lmodel2", "ggplot2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load libraries for models and data
library(lmodel2)

data(mod2ex2)
Ex2.res <- lmodel2(Prey ~ Predators, data = mod2ex2, "relative", "relative", 99)
Ex2.res

# summarize model fit with tidiers + visualization
tidy(Ex2.res)
glance(Ex2.res)

# this allows coefficient plots with ggplot2
library(ggplot2)

ggplot(tidy(Ex2.res), aes(estimate, term, color = method)) +
  geom_point() +
  geom_errorbarh(aes(xmin = conf.low, xmax = conf.high)) +
  geom_errorbarh(aes(xmin = conf.low, xmax = conf.high))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[lmodel2:lmodel2]{lmodel2::lmodel2()}}

Other lmodel2 tidiers: 
\code{\link{glance.lmodel2}()}
}
\concept{lmodel2 tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{term}{The name of the regression term.}
  \item{method}{Either OLS/MA/SMA/RMA}

}
