% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_generics.R
\name{grouped_augment}
\alias{grouped_augment}
\title{Augmented data from grouped analysis of any function that has \code{data}
argument in its function call.}
\usage{
grouped_augment(data, grouping.vars, ..f, ..., augment.args = list())
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{..f}{A function, or function name as a string.}

\item{...}{<\link[rlang:dyn-dots]{dynamic}> Arguments for \code{.fn}.}

\item{augment.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about data points.
}
\description{
Augmented data from grouped analysis of any function that has \code{data}
argument in its function call.
}
\examples{
set.seed(123)

# linear mixed effects model
broomExtra::grouped_augment(
  data = dplyr::mutate(MASS::Aids2, interval = death - diag),
  grouping.vars = sex,
  ..f = lme4::lmer,
  formula = interval ~ age + (1 | status),
  control = lme4::lmerControl(optimizer = "bobyqa")
)
}
\seealso{
\code{\link{augment}}
}
