% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_generics.R
\name{grouped_tidy}
\alias{grouped_tidy}
\title{Grouped tidy analysis}
\usage{
grouped_tidy(data, grouping.vars, ..f, ..., tidy.args = list())
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{..f}{A function, or function name as a string.}

\item{...}{<\link[rlang:dyn-dots]{dynamic}> Arguments for \code{.fn}.}

\item{tidy.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about model components.
}
\description{
Tidy output from grouped analysis of any function that has
\code{data} argument in its function call
}
\examples{
set.seed(123)
library(dplyr)

# linear mixed effects model
grouped_tidy(
  data = mutate(MASS::Aids2, interval = death - diag),
  grouping.vars = sex,
  ..f = lme4::lmer,
  formula = interval ~ age + (1 | status),
  control = lme4::lmerControl(optimizer = "bobyqa"),
  tidy.args = list(conf.int = TRUE, conf.level = 0.99)
)
}
\seealso{
\code{\link{tidy}}
}
