% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{glance}
\alias{glance}
\title{Retrieve model summary dataframe if it exists.}
\usage{
glance(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\description{
Checks if a \code{glance} method exits for a given object, either in \code{{broom}} or in
\code{{broom.mixed}}. If it does, return the model summary dataframe, if not, return
a \code{NULL}. In this case, you can try the \code{\link[=glance_performance]{glance_performance()}}
function.
}
\examples{
set.seed(123)
lm.mod <- lm(Sepal.Length ~ Species, iris)
broomExtra::glance(lm.mod)
}
\seealso{
\code{\link{grouped_glance}}, \code{\link{glance_performance}}
}
