% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{PGIBDist}
\alias{PGIBDist}
\alias{dPGIB}
\alias{pPGIB}
\alias{qPGIB}
\alias{rPGIB}
\alias{summary_PGIB}
\title{Poisson-Gamma-Inverse Beta distribution}
\usage{
dPGIB(x, a, alpha, beta, rho)

pPGIB(q, a, alpha, beta, rho)

qPGIB(p, a, alpha, beta, rho)

rPGIB(n, a, alpha, beta, rho)

summary_PGIB(a, alpha, beta, rho, output = "list", ...)
}
\arguments{
\item{x,q}{vector of \strong{integer} quantiles}

\item{a}{non-negative shape parameter of the Gamma distribution}

\item{alpha,beta}{non-negative shape parameters of the mixing Beta distribution}

\item{rho}{hyperrate parameter (rate of the mixing distribution)}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{output}{type of the \code{summary_PGIB} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}

\item{...}{arguments passed to \code{\link[=pander]{pander.data.frame}}}
}
\value{
\code{dPGIB} gives the density, \code{rPGIB} samples from the distribution,
and \code{summary_PGIB} gives a summary of the distribution.
}
\description{
Density and random  generation for the Poisson-Gamma-Inverse Beta distribution
with shape parameters \code{a}, \code{c}, \code{d} and scale parameter \code{rho}.










}
\details{
This is the mixture distribution obtained by sampling a value from a
\link[=GIBDist]{Gamma-Inverse Beta distribution} and then sampling from
a Poisson distribution having this value as mean.
}
\note{
\code{PGIBDist} is a generic name for the functions documented.
}
\examples{
barplot(dPGIB(0:5, a=13, alpha=4, beta=2, rho=2.5), names=0:5)
summary_PGIB(13, 4, 2, 2.5)
}

