% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_accordion}
\alias{bs_accordion}
\title{Create a Bootstrap accordion}
\usage{
bs_accordion(
  id,
  items = list(),
  expand = c(),
  button_background_color = NULL,
  button_text_color = NULL,
  accordion_attr = list(class = "accordion"),
  item_attr = list(class = "accordion-item"),
  item_header_attr = list(class = "accordion-header"),
  button_attr = list(class = "accordion-button collapsed"),
  div_attr = list(class = "accordion-collapse collapse"),
  body_attr = list(class = "accordion-body")
)
}
\arguments{
\item{id}{A string, the id to use for the accordion, must be unique within a page (if you have multiple accordions on a page).}

\item{items}{A named list, names become the label for each panel, values should be the HTML content to display
when the panel is toggled.}

\item{expand}{A vector, the names or positions of panels that should be expanded by default.}

\item{button_background_color}{A string vector, the color to apply to the background of the accordion toggle button. Recycles for each panel.}

\item{button_text_color}{A string vector, the color to apply to the text of the accordion toggle button. Recycles for each panel.}

\item{accordion_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the accordion content.}

\item{item_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the accordion items.}

\item{item_header_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the accordion panel headers.}

\item{button_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the accordion panel header button items.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the accordion panel content.}

\item{body_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the accordion panel content body.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/accordion/}.
}
\examples{
bs_accordion(
id = "acc1",
items = list(
  "One" = p("Check it out."),
  "Two" = p("Does it work?"),
  "Three" = p("I hope so.")
)
)
}
