% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_offcanvas}
\alias{bs_offcanvas}
\title{Create a Bootstrap offcanvas}
\usage{
bs_offcanvas(
  id = "offcanvas",
  header,
  title = NULL,
  body,
  offcanvas_attr = c(class = "offcanvas offcanvas-start", tabindex = "-1",
    `aria-labelledby` = "offcanvasLabel"),
  header_attr = c(class = "offcanvas-header"),
  title_attr = c(class = "offcanvas-title", id = "offcanvasLabel"),
  body_attr = c(class = "offcanvas-body"),
  title_function = h5
)
}
\arguments{
\item{id}{A string, the id for the div of the offcanvas.}

\item{header}{A string, the HTML to display in the header of the offcanvas.}

\item{title}{A string, the HTML to display in the title of the offcanvas.}

\item{body}{A string, the HTML to display in the body of the offcanvas.}

\item{offcanvas_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the offcanvas content.}

\item{header_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the offcanvas header.}

\item{title_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the tag containing the offcanvas title.}

\item{body_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the offcanvas body.}

\item{title_function}{A function, most likely from the html5 package, containing the attr parameter to be used to generate the title, defaults to h5.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap offcanvas
}
\examples{
bs_offcanvas(
header = "Hello",
body = p("This is a offcanvas.")
)
}
