% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_scagnostics.R
\name{pair_scagnostics}
\alias{pair_scagnostics}
\title{Graph-theoretic scagnostics values}
\usage{
pair_scagnostics(
  d,
  scagnostic = c("Outlying", "Skewed", "Clumpy", "Sparse", "Striated", "Convex",
    "Skinny", "Stringy", "Monotonic"),
  handle.na = TRUE,
  ...
)
}
\arguments{
\item{d}{A dataframe}

\item{scagnostic}{a character vector for the scagnostic to be calculated. Subset of "Outlying",
"Stringy", "Striated", "Clumpy", "Sparse", "Skewed", "Convex", "Skinny" or "Monotonic"}

\item{handle.na}{If TRUE uses pairwise complete observations.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with  scagnostic values for every numeric variable pair,
or NULL if there are not at least two numeric variables
}
\description{
Calculates  scagnostic values for every numeric variable pair in a dataset.
}
\details{
The scagnostic values are calculated using \code{\link[scagnostics]{scagnostics}}
function from the \code{scagnostics} package.
}
\examples{
 pair_scagnostics(iris)
}
\references{
Wilkinson, Leland, Anushka Anand, and Robert Grossman.
"Graph-theoretic scagnostics."
Information Visualization, IEEE Symposium on. IEEE Computer Society, 2005
}
