% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_priors.R
\name{add_priors}
\alias{add_priors}
\title{Add Priors to Bayesian Models
 
A generic function used to generate prior specifications for a list of models. The
function invokes particular methods which depend on the class of the first argument.}
\usage{
add_priors(object, ...)
}
\arguments{
\item{object}{an object of class \code{"bvarmodel"} or \code{"bvecmodel"}.}

\item{...}{arguments passed forward to method.}
}
\description{
Add Priors to Bayesian Models
 
A generic function used to generate prior specifications for a list of models. The
function invokes particular methods which depend on the class of the first argument.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Obtain data matrices
model <- gen_var(e1, p = 2, deterministic = 2,
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burn-in draws should be much higher.

# Add prior specifications
model <- add_priors(model)

}
