% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{oxfordman}
\alias{oxfordman}
\alias{oxfordman_rv}
\alias{oxfordman_rk}
\title{Oxford-Man Institute Realized Library}
\format{
\code{oxfordman_long} is the raw data frame of 53507 rows and 20 columns (You cannot call this dataset.):

\describe{
\item{date}{Date - From 2012-01-09 to 2015-06-27}
\item{Symbol}{Name of the Assets - See below for each name}
\item{nobs}{Number of observations}
\item{by_ss}{Bipower Variation (5-min Sub-sampled)}
\item{rsv}{Realized Semi-variance (5-min)}
\item{rk_parzen}{Realized Kernel Variance (Non-Flat Parzen)}
\item{rv10}{Realized Variance (10-min)}
\item{rv5_ss}{Realized Variance (5-min Sub-sampled)}
\item{rv5}{Realized Variance (5-min)}
\item{rv10_ss}{Realized Variance (10-min Sub-sampled)}
\item{rk_twoscale}{Realized Kernel Variance (Two-Scale/Bartlett)}
\item{close_price}{Closing (Last) Price}
\item{rsv_ss}{Realized Semi-variance (5-min Sub-sampled)}
\item{rk_th2}{Realized Kernel Variance (Tukey-Hanning(2))}
\item{open_time}{Opening Time}
\item{medrv}{Median Realized Variance (5-min)}
\item{open_price}{Opening (First) Price}
\item{bv}{Bipower Variation (5-min)}
\item{open_to_close}{Open to Close Return}
\item{close_time}{Closing Time}
}

\code{oxfordman_rv} is a data frame that interpolates \code{NA} values of \code{oxfordman_wide_rv}.
Also, it does not have \code{date} column for fitting.
The number of rows is 905 and the number of columns is 30 (except date).
\describe{
\item{date}{Date - From 2012-01-09 to 2015-06-27}
\item{AEX}{AEX index}
\item{AORD}{All Ordinaries}
\item{BFX}{Bell 20 Index}
\item{BSESN}{S&P BSE Sensex}
\item{BVLG}{PSI All-Share Index (excluded because this index is observed from 2012-10-15)}
\item{BVSP}{BVSP BOVESPA Index}
\item{DJI}{Dow Jones Industrial Average}
\item{FCHI}{CAC 40}
\item{FTMIB}{FTSE MIB}
\item{FTSE}{FTSE 100}
\item{GDAXI}{DAX}
\item{GSPTSE}{S&P/TSX Composite index}
\item{HSI}{HANG SENG Index}
\item{IBEX}{IBEX 35 Index}
\item{IXIC}{Nasdaq 100}
\item{KS11}{Korea Composite Stock Price Index (KOSPI)}
\item{KSE}{Karachi SE 100 Index}
\item{MXX}{IPC Mexico}
\item{N225}{Nikkei 225}
\item{NSEI}{NIFTY 50}
\item{OMXC20}{OMX Copenhagen 20 Index}
\item{OMXHPI}{OMX Helsinki All Share Index}
\item{OMXSPI}{OMX Stockholm All Share Index}
\item{OSEAX}{Oslo Exchange All-share Index}
\item{RUT}{Russel 2000}
\item{SMSI}{Madrid General Index}
\item{SPX}{S&P 500 Index}
\item{SSEC}{Shanghai Composite Index}
\item{SSMI}{Swiss Stock Market Index}
\item{STI}{Straits Times Index (excluded because this index is NA in the period)}
\item{STOXX50E}{EURO STOXX 50}
}

\code{oxfordman_rk} is a data frame that interpolates \code{NA} values of \code{oxfordman_wide_rk}.
Also, it does not have \code{DATE} column for fitting.
The number of rows is 1826 and the number of columns is 31.
}
\source{
Realized library of oxford-man had been discontinued, so the source could not be listed.
}
\usage{
oxfordman_rv

oxfordman_rk
}
\description{
The realized measure of financial assets dataset provided by \href{https://oxford-man.ox.ac.uk/research/realized-library/}{Oxford-man Institute of Quantitative Finance}.
}
\details{
\itemize{
\item As a raw dataset, we have internal dataset of long format \code{oxfordman_long}. It contains every realized measure.
\item Denote that non-trading dates are excluded in \code{oxfordman_long}, not in \code{NA}. So be careful when dealing this set directly.
\item For analysis, we widened the data for 5-min realized volatility (\code{rv5}) and realized kernel variance (\code{rk_parzen}), respectively.
\itemize{
\item \code{oxfordman_wide_rv}
\item \code{oxfordman_wide_rk}
}
\item \code{oxford_rv} and \code{oxford_rk} are the sets whose \code{NA} values interpolated using \code{imputeTS::na_interpolation()}.
\item First three datasets should be called using \code{\link[=data]{data()}} function: \code{data(..., package = "bvhar")}.
\item Only \code{oxford_rv} and \code{oxford_rk} is lazy loaded.
}
}
\keyword{datasets}
