% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R, R/print-irf.R
\name{analyze_ir.varlse}
\alias{analyze_ir.varlse}
\alias{analyze_ir.vharlse}
\alias{print.bvharirf}
\alias{analyze_ir}
\alias{knit_print.bvharirf}
\title{Impulse Response Analysis}
\usage{
\method{analyze_ir}{varlse}(
  object,
  lag_max = 10,
  orthogonal = TRUE,
  impulse_var,
  response_var,
  ...
)

\method{analyze_ir}{vharlse}(
  object,
  lag_max = 10,
  orthogonal = TRUE,
  impulse_var,
  response_var,
  ...
)

\method{print}{bvharirf}(x, digits = max(3L, getOption("digits") - 3L), ...)

analyze_ir(object, lag_max, orthogonal, impulse_var, response_var, ...)

\method{knit_print}{bvharirf}(x, ...)
}
\arguments{
\item{object}{Model object}

\item{lag_max}{Maximum lag to investigate the impulse responses (By default, \code{10})}

\item{orthogonal}{Orthogonal impulses (\code{TRUE}) or just impulses (\code{FALSE})}

\item{impulse_var}{Impulse variables character vector. If not specified, use every variable.}

\item{response_var}{Response variables character vector. If not specified, use every variable.}

\item{...}{not used}

\item{x}{\code{bvharirf} object}

\item{digits}{digit option to print}
}
\value{
\code{bvharirf} \link{class}
}
\description{
Computes responses to impulses or orthogonal impulses
}
\section{Responses to forecast errors}{

If \code{orthogonal = FALSE}, the function gives \eqn{W_j} VMA representation of the process such that
\deqn{Y_t = \sum_{j = 0}^\infty W_j \epsilon_{t - j}}
}

\section{Responses to orthogonal impulses}{

If \code{orthogonal = TRUE}, it gives orthogonalized VMA representation \deqn{\Theta}.
Based on variance decomposition (Cholesky decomposition)
\deqn{\Sigma = P P^T}
where \eqn{P} is lower triangular matrix,
impulse response analysis if performed under MA representation
\deqn{y_t = \sum_{i = 0}^\infty \Theta_i v_{t - i}}
Here,
\deqn{\Theta_i = W_i P}
and \eqn{v_t = P^{-1} \epsilon_t} are orthogonal.
}

\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
\seealso{
\code{\link[=VARtoVMA]{VARtoVMA()}}

\code{\link[=VHARtoVMA]{VHARtoVMA()}}
}
