% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPercentileSeries}
\alias{plotPercentileSeries}
\title{Generates a series of plots with number curves by percentile for different models}
\usage{
plotPercentileSeries(
  data,
  model,
  start = 1,
  end = NULL,
  group = NULL,
  percentiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  type = 7,
  filename = NULL
)
}
\arguments{
\item{data}{The raw data including the percentiles and norm scores}

\item{model}{The model from the bestModel function}

\item{start}{Number of predictors to start with}

\item{end}{Number of predictors to end with}

\item{group}{The name of the grouping variable; the distinct groups are automatically
determined}

\item{percentiles}{Vector with percentile scores, ranging from 0 to 1 (exclusive)}

\item{type}{The type parameter of the quantile function to estimate the percentiles
of the raw data (default 7)}

\item{filename}{Prefix of the filename. If specified, the plots are saves as
png files in the directory of the workspace, instead of displaying them}
}
\value{
the complete list of plots
}
\description{
This functions makes use of 'plotPercentiles' to generate a series of plots
with different number of predictors. It draws on the information provided by the model object
to determine the bounds of the modeling (age and standard score range). It can be used as an
additional model check to determine the best fitting model. Please have a look at the
' plotPercentiles' function for further information.
}
\examples{
# Load example data set, compute model and plot results
normData <- prepareData(elfe)
model <- bestModel(data = normData)
plotPercentileSeries(normData, model, start=1, end=5, group="group")
}
\seealso{
plotPercentiles
}
