% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSubset}
\alias{plotSubset}
\title{Evaluate information criteria for regression model}
\usage{
plotSubset(model, type = 1, index = FALSE)
}
\arguments{
\item{model}{The regression model from the bestModel function}

\item{type}{Type of chart with 0 = adjusted R2 by number of predictors,
1 = log transformed Mallow's Cp by adjusted R2, 2 = Bayesian Information
Criterion (BIC) by adjusted R2 and 3 = Root Mean Square Error (RMSE) by number
of predictors}

\item{index}{add index labels to data points}
}
\description{
Plots the information criterion - either Cp (default) or BIC - against
the adjusted R square of the feature selection in the modeling process.
Both BIC and Mallow's Cp are measures to avoid over-fitting. Please
choose the model that has a high information criterion, while modeling
the original data as close as possible. R2 adjusted values of ~ .99 might
work well, depending on your scenario. In other words: Look out for the
elbow in the curve and choose th model where the information criterion
begins to drop. Nonetheless, inspect the according model with \code{plotPercentiles(data, group)}
to visually inspect the course of the percentiles.
In the plot, Mallow's Cp is log transformed and the BIC is always highly
negative. The R2 cutoff that was specified in the bestModel function is
displayed as a dashed line.
}
\examples{
normData <- prepareData()
m <- bestModel(data = normData)
plotSubset(m)
}
\seealso{
bestModel, plotPercentiles, printSubset
}
