% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{betaContinuous}
\alias{betaContinuous}
\title{Continuous Norming with Beta-Binomial Distribution (experimental)}
\usage{
betaContinuous(param, powerA = Inf, powerB = Inf)
}
\arguments{
\item{param}{A data frame containing the columns `a`, `b`, `group`, and `n`. Each row should represent
a distinct group with its corresponding beta-binomial parameters and the group identifier. These
parameters can be obtained with the 'betaByGroup' function.}

\item{powerA}{The degree of the polynomial used to model the `a` parameter across groups. Please choose
\eqn{powerA \leq k} with k being the number of groups.}

\item{powerB}{The degree of the polynomial used to model the `b` parameter across groups. Please choose
\eqn{powerB \leq k} with k being the number of groups.}
}
\value{
A list containing several components:
`manifestParameters` with the input parameters,
`powerA` and `powerB` showing the polynomial degrees used,
`modA` and `modB` with the polynomial regression models for `a` and `b` parameters.
}
\description{
This function models the alpha (`a`) and beta (`b`) parameters of the beta-binomial distribution
across groups using polynomial regression. It then calculates the distribution's properties
(cumulative probabilities, density, percentiles, and z-scores) for these modeled parameters.
The modeling of `a` and `b` allows for the investigation of how these parameters vary with a continuous
group variable, allowing for continuous norming.
}
\details{
The function first fits polynomial regression models for `a` and `b` against a continuous group variable,
allowing for non-linear trends in how the shape parameters of the beta-binomial distribution change with the group.
It then predicts `a` and `b` for each group, using these predicted values to calculate the beta-binomial
distribution's properties for each group. This approach facilitates understanding the variability and
dynamics of the distribution across different conditions or groups.
}
\examples{
param <- data.frame(a = c(1,2,3), b = c(2,3,4), group = c(1,2,3), n = c(30,30,30))
powerA <- 2
powerB <- 2
betaContinuous(param, powerA, powerB)
}
