% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_calendar.R
\name{as_date}
\alias{as_date}
\alias{new_date}
\title{Create a new date vector or convert a date vector to a new calendar}
\usage{
as_date(date, calendar)

new_date(..., calendar)
}
\arguments{
\item{date}{Date vector on some calendar}

\item{calendar}{Target calendar of class "calendar"}

\item{...}{Named arguments denoting the granularities required for \code{calendar}.}
}
\value{
A date vector of class "rdvec" with the specified calendar.
}
\description{
New dates can be calculated using \code{new_date()} for any calendar. Dates can be
converted from one calendar to another using \code{as_date()}. \code{as_date()} also works
with the native R \code{Date} class and several other classes. When applied to
integers, the conversion is from the RD day number (with day 1 being
01-01-01 on the Gregorian calendar).
}
\examples{
april2025 <- new_date(year = 2025, month = 4, day = 1:30, calendar = cal_gregorian)
as_date(april2025, calendar = cal_iso)
}
