% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd.R
\name{rcmd}
\alias{rcmd}
\title{Run an R CMD command}
\usage{
rcmd(cmd, cmdargs = character(), libpath = .libPaths(),
  repos = getOption("repos"), stdout = NULL, stderr = NULL,
  show = FALSE, callback = NULL, system_profile = FALSE,
  user_profile = FALSE, env = character())
}
\arguments{
\item{cmd}{Command to run. See \code{R --help} from the command
line for the various commands. In the current version of R (3.2.4)
these are: BATCH, COMPILE, SHLIB, INSTALL, REMOVE, build, check,
LINK, Rprof, Rdconv, Rd2pdf, Rd2txt, Stangle, Sweave, Rdiff, config,
javareconf, rtags.}

\item{cmdargs}{Command line arguments.}

\item{libpath}{The library path.}

\item{repos}{The \sQuote{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set to \code{FALSE},
as it is set using the system or the user profile.}

\item{stdout}{Optionally a file name to send the standard output to.}

\item{stderr}{Optionally a file name to send the standard error to.}

\item{show}{Logical, whether to show the standard output on the screen
while the child process is running. Note that this is independent
of the \code{stdout} and \code{stderr} arguments. The standard
error is not shown currently.}

\item{callback}{A function to call for each line of the standard
output from the child process. It works together with the \code{show}
option; i.e. if \code{show = TRUE}, and a callback is provided, then
the output is shown of the screen, and the callback is also called.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.}

\item{env}{Environment variables to set for the child process.}
}
\value{
A list with the standard output (\code{$stdout}), standard
  error (\code{stderr}) and exit status (\code{$status}) of the
  external \code{R CMD} command.
}
\description{
Run an R CMD command form within R. This will usually start
another R process, from a shell script.
}
\examples{
rcmd("config", "CC")
}
\seealso{
Other R CMD commands: \code{\link{rcmd_safe}}
}

