% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_design.R
\name{parse_design}
\alias{parse_design}
\title{Parse design data.frame}
\usage{
parse_design(df, model = NULL, ...)
}
\arguments{
\item{df}{A \code{data.frame} of dimensions (groups) by (2*phases+1).}

\item{model}{(Optional) model to augment the design.}

\item{...}{Other arguments passed to augment function.}
}
\value{
A \linkS4class{CalmrDesign} object.
}
\description{
Parse design data.frame
}
\note{
Each entry in even-numbered columns of df is
a string formatted as per \code{\link[=phase_parser]{phase_parser()}}.
}
\examples{
df <- data.frame(
  Group = c("Group 1", "Group 2"),
  P1 = c("10AB(US)", "10A(US)"), R1 = c(TRUE, TRUE)
)
parse_design(df)
}
\seealso{
\code{\link[=phase_parser]{phase_parser()}}
}
