% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-diary.R
\name{use_diary}
\alias{use_diary}
\title{Create a new template data diary}
\usage{
use_diary(st, type, author, auto = FALSE)
}
\arguments{
\item{st}{The USPS state abbreviation.}

\item{type}{The type of data, one of "contribs", "expends", or "lobby".}

\item{author}{The author name of the new diary.}

\item{auto}{If \code{TRUE}, file is created in the correct working directory.
If \code{FALSE}, a plain character string is returned. If a directory name, the
file is automatically written to that directory.}
}
\value{
The file path of new diary, invisibly.
}
\description{
Take the arguments supplied and put them into the appropriate places in a
new template diary. Write the new template diary in the supplied directory.
}
\examples{
use_diary("VT", "contribs", "Kiernan Nicholls", FALSE)
use_diary("VT", "contribs", "Kiernan Nicholls", tempdir())
}
