% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_uncertainty_utils.R
\name{sampleGeneric}
\alias{sampleGeneric}
\title{Generic function for parameter sampling according to the minimum and maximum values.
This function will sample parameters a first time and check if some parameters are out of range.
Based on the success rate, it will sample more parameters to reach the desired number of rows.}
\usage{
sampleGeneric(fun, args, n, minMax, msg, settings, parameters = NULL)
}
\arguments{
\item{fun}{function to call to sample parameters}

\item{args}{arguments to pass to the function}

\item{n}{number of rows to sample}

\item{minMax}{a data frame with min, max values for each parameter}

\item{msg}{message template}

\item{settings}{replication settings}

\item{parameters}{double array parameters to check for positive definiteness}
}
\value{
tibble with the sampled parameters (1 parameter per column + REPLICATE column)
}
\description{
Generic function for parameter sampling according to the minimum and maximum values.
This function will sample parameters a first time and check if some parameters are out of range.
Based on the success rate, it will sample more parameters to reach the desired number of rows.
}
\keyword{internal}
