% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancensus.R
\name{label_vectors}
\alias{label_vectors}
\title{Return Census variable names and labels as a tidy data frame}
\usage{
label_vectors(x)
}
\arguments{
\item{x}{A data frame, \code{sp} or \code{sf} object returned from
\code{get_census} or similar.}
}
\value{
A data frame with a column \code{variable} containing the truncated
variable name, and a column \code{label} describing it.
}
\description{
Return Census variable names and labels as a tidy data frame
}
\examples{

\dontrun{
# Query census data with truncated labels:
label_data <- get_census(dataset='CA16', regions=list(CMA="59933"),
                          vectors=c("v_CA16_408","v_CA16_409","v_CA16_410"),
                          level='CSD', geo_format = "sf", labels="short")

# Get details for truncated vectors:
label_vectors(label_data)
}
}
